package com.peak.common.util;
/**
 * 数据脱敏工具类，例如：身份证号脱敏规则：仅显示后4位，其他的使用星号代替。
 * @author weizhenyong
 * @date 2025/2/20 17:02
 */
public class DataMaskUtil {


    /**
     * 对身份证号进行脱敏，仅显示后4位，其他位显示*
     * @param idCard 身份证号
     * @return 脱敏后的身份证号
     * @author weizhenyong
     * @date 2025/2/20 17:11
     */
    public static String idCardMask(String idCard) {
        if (StringUtil.isNullorEmptyStr(idCard)) {
            return idCard;
        }
        // 脱敏规则，光大信用卡：保留前0位，18位身份证保留后4位，15位保留后4位
        int KEEP_START = 0;
        int KEEP_END_18 = 4;
        int KEEP_END_15 = 4;


        int length = idCard.length();
        // 校验身份证长度合法性
        if (length != 15 && length != 18) {
            throw new IllegalArgumentException("非法身份证号长度(idcard length is error!)");
        }

        // 计算保留的末尾位数
        int endKeep = (length == 18) ? KEEP_END_18 : KEEP_END_15;
        // 截取前0位和末尾保留部分
        String start = idCard.substring(0, KEEP_START);
        String end = idCard.substring(length - endKeep);

        // 计算所需要的星的个数
        int starCount = length - KEEP_START - endKeep;
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < starCount; i++) {
            stars.append("*");
        }

        return start + stars.toString() + end;
    }
    /**
     * 对手机号进行脱敏
     * @param phonenum 手机号
     * @return 脱敏后的手机号
     * @author weizhenyong
     * @date 2025/2/20 17:18
     */
    public static String phonenumMask(String phonenum) {
        if (StringUtil.isNullorEmptyStr(phonenum)) {
            return phonenum;
        }
        // 脱敏规则：保留前3位，保留后4位
        int KEEP_START = 3;
        int KEEP_END = 4;


        int length = phonenum.length();
        // 校验身份证长度合法性
        if (length != 11) {
            throw new IllegalArgumentException("非法手机号长度(phonenum length is error!)");
        }


        // 截取前0位和末尾保留部分
        String start = phonenum.substring(0, KEEP_START);
        String end = phonenum.substring(length - KEEP_END);

        // 计算所需要的星的个数
        int starCount = length - KEEP_START - KEEP_END;
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < starCount; i++) {
            stars.append("*");
        }

        return start + stars.toString() + end;
    }

}
