package com.peak.common.util;
 
import java.io.IOException; 
import java.text.DecimalFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 保留两位小数的序列化器
 * @author xiaqing
 *
 */
public class Double2Serializer extends JsonSerializer<Double>{
	private DecimalFormat df = new  DecimalFormat("0.00");

	@Override
	public void serialize(Double value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
		if(value != null) {
			if(value == 0) {
				gen.writeString("0");
			}else {
				gen.writeString(df.format(value));
			}
		}
		
	}

}
