package com.peak.common.util;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

//import com.peak.prd.config.EmailConfig;

/**
 * Email工具服务类
 * @author zhangdexin
 *
 */
public class EmailService {
	
//	@Autowired
//	EmailConfig emailConfig;
	
	@Autowired
	JavaMailSenderImpl javaMailSender;
	
	public void send(String to, String subject, String content) throws Exception {
		SimpleMailMessage msg = new SimpleMailMessage();
		msg.setTo(to);
		msg.setText(content);
		msg.setSubject(subject);
		send(msg);
	}
	
	public void send(SimpleMailMessage msg) {
		msg.setFrom(javaMailSender.getUsername());
		javaMailSender.send(msg);
//		AsyncToken token = asyncMailSender.send(msg);
//		token.addResponder(new IResponder() {
//			public void onFault(Exception e) {
//				e.printStackTrace();
//			}
//			public void onResult(Object result) {
//			}
//		});
	}
	
	/** 发邮件
	 * @param to 收件人
	 * @param subject 主题
	 * @param content 内容
	 * @throws MessagingException 
	 */
//	private void send1(String to, String subject, String content) throws MessagingException {
//		
//		String from = emailConfig.getFrom(); // "a18500878133@126.com";
//        String smtpHost = emailConfig.getSmtp(); // "smtp.126.com";
//        Properties props = new Properties();
//        props.setProperty("mail.transport.protocol", "smtp"); // 使用的协议（JavaMail规范要求）
//        props.setProperty("mail.smtp.host", smtpHost); // 发件人的邮箱的 SMTP服务器地址
//        props.setProperty("mail.smtp.auth", "true"); // 请求认证，参数名称与具体实现有关
//        // 创建Session实例对象
//        Session session = Session.getDefaultInstance(props);
//        // 创建MimeMessage实例对象
//        MimeMessage message = new MimeMessage(session);
//        // 设置发件人
//        message.setFrom(new InternetAddress(from));
//        // 设置收件人
//        message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
//        // 设置发送日期
//        message.setSentDate(new Date());
//        // 设置邮件主题
//        message.setSubject(subject);
//        // 设置纯文本内容的邮件正文
//        message.setText(content);
//        // 保存并生成最终的邮件内容
//        message.saveChanges();
//        // 设置为debug模式, 可以查看详细的发送 log
//        session.setDebug(true);
//        // 获取Transport对象
//        Transport transport = session.getTransport("smtp");
//        // 第2个参数需要填写的是QQ邮箱的SMTP的授权码，什么是授权码，它又是如何设置？
//        transport.connect(from, emailConfig.getGrantCode()); // IQPKNXHAPPNMUKJM
//        // 发送，message.getAllRecipients() 获取到的是在创建邮件对象时添加的所有收件人, 抄送人, 密送人
//        transport.sendMessage(message, message.getAllRecipients());
//        transport.close();
//	}

}