package com.peak.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;

/**
 * 
 * <p>文件名列表Excel导出工具类</p>
 * @author ldc
 * @date   2023年9月18日 下午5:21:54
 *
 */
public class FilenameListExcelExportUtil {

	private final class FilenameListExcelModel {
		
		@ExcelProperty(value="源代码路径")
		@ColumnWidth(value = 80)
		private String filepathname;
		
		@ExcelProperty(value="名称（文件）")
		@ColumnWidth(value = 40)
		private String filename;
		
		@ExcelProperty(value="备注")
		@ColumnWidth(value = 60)
		private String notes;

		public String getFilepathname() {
			return filepathname;
		}

		public void setFilepathname(String filepathname) {
			this.filepathname = filepathname;
		}

		public String getFilename() {
			return filename;
		}

		public void setFilename(String filename) {
			this.filename = filename;
		}

		public String getNotes() {
			return notes;
		}

		public void setNotes(String notes) {
			this.notes = notes;
		}
	}
	
	/**
	 * <p>获得java文件备注</p>
	 * @param filepath
	 * @return
	 * @author ldc
	 * @date   2023年9月18日 下午5:46:47
	 */
	private static String getNotes(String filepath) {
		String notes = "";
		//只有java文件才取备注
		if(filepath.indexOf(".java") == -1) return notes;
		
        try{
        	File file = new File(filepath);
            BufferedReader br = new BufferedReader(new FileReader(file));//构造一个BufferedReader类来读取文件
            String s = null;
            int index = 0;
            while((s = br.readLine())!=null){//使用readLine方法，一次读一行
            	//超过80行就不取备注了
            	if(index > 80) break;
            	
            	if(s.indexOf("<p>") > -1) {
            		notes = s.replace("<p>", "").replace("</p>", "").replace("*", "").trim();
            		break;
            	}

            	if(s.indexOf("@description") > -1) {
            		notes = s.replace("@description", "").replace("*", "").trim();
            		break;
            	}
            	
            	//generator自动生成的可以要可以不要要的话就打开注释
//            	if(s.indexOf("功能描述:") > -1) {
//            		notes = s.replace("功能描述:", "").replace("*", "").trim();
//            		break;
//            	} 
            	
            	index ++;
            }
            br.close();    
        }catch(Exception e){
            e.printStackTrace();
        }
        return notes;
	}
	
	/**
	 * <p>执行导出操作</p>
	 * @param filepath			需要导出文件路径，如 D:\\work\\project\\prd-business\\src\\main\\
	 * @param excelpath		生成的excel路径+名称。如 D:\\代码清单.xlsx
	 * @param sheetname		sheet页名称
	 * @author ldc
	 * @date   2023年9月18日 下午6:43:30
	 */
	private static void executeExportInfo(String filepath, String excelpath, String sheetname) {
		List<FilenameListExcelModel> excelModelList = new ArrayList<>();
		//获得filepath下所有的完整文件路径列表
		List<String> fullfilenameList = FileUtil.getFilepaths(filepath);
		
		FilenameListExcelExportUtil exportUtil = new FilenameListExcelExportUtil();
		
		for(String filepathname : fullfilenameList) {
			FilenameListExcelModel excelModel = exportUtil.new FilenameListExcelModel();
			excelModel.setFilepathname(filepathname.replace(filepath, ""));
			excelModel.setFilename(filepathname.substring(filepathname.lastIndexOf("\\") + 1));
			excelModel.setNotes(getNotes(filepathname));
			excelModelList.add(excelModel);
		}
		
		ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(excelpath, FilenameListExcelModel.class);

		//一次最多导出2000个
		int toIndex = 2000; 
		for (int i=0; i<excelModelList.size(); i+= 2000) {
            if (i + 2000 > excelModelList.size()) {
                toIndex = excelModelList.size() - i;
            }
            List<FilenameListExcelModel> exportList = excelModelList.subList(i, i + toIndex);
            //一次最多导出2000条数据
            excelWriteUtil.excelWrite(sheetname, exportList, "this$0");
        }

		if(excelWriteUtil != null) {
			//写入结束关闭流
			excelWriteUtil.finishWrite();
		}
	}

	public static void main(String[] args) {
		
		executeExportInfo("D:\\work\\project\\prd-business\\src\\main\\", "D:\\代码清单.xlsx", "代码清单");
		
	}
	
}
