package com.peak.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/**
 * 功能描述: 格式化处理常用方法
 * @author liudachang
 * @version 1.0
 * @since 1.0   - 2021-02-24 
 */
public class FormatUtil {
	
	public static final String NEWFORMAT_TIME = "formatTime";
	public static final String TIME_UNIT = "timeUnit";
	
	/**
	   *  获得格式化后的显示时间和单位，
						小于1分钟：显示秒
						小于1小时：显示分钟
						大于1小时：显示小时

	 * @param second	需要格式化的时间（秒）
	 * 
	 * @return			返回值Map中的值说明
	 * 					formatTime=格式化后的时间保留一位小数
						timeUnit=格式化后的时间单位
	 */
	public static Map<String, String> getNewFormatTime(long second) {
		double formatTime = 0D;
		String timeUnit = "";
		if(second >= 3600) {
			formatTime = second / 3600.0;
			timeUnit = "小时";
		} else if(second >= 60) {
			formatTime = second / 60.0;
			timeUnit = "分钟";
		} else {
			formatTime = second;
			timeUnit = "秒";
		}
		Map<String, String> resultMap = new HashMap<String, String>(2);
		resultMap.put(NEWFORMAT_TIME, String.format("%.1f", formatTime).replace(".0", ""));
		resultMap.put(TIME_UNIT, timeUnit);
		return resultMap;
	}
	
	/**
	 * 获得num位小数的数
	 * @param originVaue 原始数
	 * @param num 精度，保留多少位小数
	 * @return 采用四舍五入保留num位小数
	 */
	public static double toScale(double originVaue, int num) {
		return new BigDecimal(originVaue).setScale(num, BigDecimal.ROUND_HALF_UP).doubleValue();
	}
	
	/**
	 * 如果是小数保留num位小数的数，如果是整数则返回整数
	 * @param originVaue 原始数
	 * @param num 精度，保留多少位小数
	 * @return 如果是小数保留num位小数的数，如果是整数则返回整数
	 */
	public static String toScaleStr(double originVaue,  int num) {
		if ((long) originVaue ==  originVaue) {
			return String.valueOf((long) originVaue);
		} else {
			double a = toScale(originVaue,num);
			return String.valueOf(a);
		}		
		
	}
	
	/**
	 * <p>一个数转换成多个包含的二进制数组</p>
	 * @param num10
	 * @param numSequence
	 * @return
	 * @author ldc
	 * @date   2023年12月22日 下午3:28:28
	 */
	public static List<Integer> toBinaryArray(Integer num10, int numSequence){
		Vector<Integer> num2 = new Vector();
		String m = Integer.toBinaryString(num10);
		char[] mc = m.toCharArray();
		if(mc==null || mc.length==0) return null;
		for(int i=0;i<mc.length;i++){
			int bit = mc.length-i-1; //标记为哪一位，第0位，第1位...
			int n = (int)mc[i]-48;
			if(n!=0) num2.add((int)Math.pow(2d, (double)bit));
		}
		Integer[] ret = new Integer[num2.size()];
		//逆序
		if(numSequence==1){
			for(int i=0;i<ret.length;i++){
				ret[i] = num2.get(num2.size()-i-1);
			}
		}
		
		Integer[] valuearray = num2.toArray(ret);
		List<Integer> relist = new ArrayList<>();
		for(Integer value : valuearray) {
			relist.add(value);
		}
		
		return relist;
	}
	/**
	 * 保留2为小数，不足两位补0，多余2为采用四舍五入
	 * @param originVaue 原始值
	 * @return 保留2为小数，不足两位补0，多余2为采用四舍五入
	 * @author wzy
	 * @date 2023/12/22 22:56
	 */
	public static String toScaleTwoStr(Double originVaue) {
		if (originVaue == null) {
			originVaue = 0.0D;
		}
		originVaue = FormatUtil.toScale(originVaue,2);
		DecimalFormat decimalFormat = new DecimalFormat("0.00#");
        return decimalFormat.format(originVaue);

	}

	
	public static void main(String[] args) {
		Integer a = 13;
		Integer b = 13;
		double a1 = a/(double)b;

	}
	
}
