package com.peak.common.util;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 功能描述: http操作相关类
 * @author 魏振永
 * @version 1.0
 * @since 1.0   - 2014-9-12 
 */
public class HttpUtil {
	/**
	 * 执行doget操作，默认采用UTF-8编码获得数据流,默认超时时间为5分钟
	 * @param url 访问的URL地址
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String doGet(String url) {
		return doGet(url,"UTF-8",1000*60*5);
	}
	/**
	 * 执行doget操作，默认采用UTF-8编码获得数据流
	 * @param url 访问的URL地址
	 * @param timeout 设置超时时间，单位毫秒
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String doGet(String url,Integer timeout) {
		return doGet(url,"UTF-8",timeout);
	}
	/**
	 * 执行doget操作,默认超时时间为5分钟
	 * @param url 访问URL地址
	 * @param charset  获得数据流编码	 * 
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String doGet(String url,String charset) {
		return doGet(url,charset,1000*60*5);
	}
	/**
	 * 执行doget操作
	 * @param url 访问URL地址
	 * @param charset  获得数据流编码
	 * @param timeout 设置超时时间，单位毫秒
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String doGet(String url,String charset,Integer timeout) {
		CloseableHttpClient  httpclient  =  HttpClients.createDefault();
		
		String rtn = "";
		try {                                                                                                  
		    // 创建httpget.                                                                                    
		    HttpGet httpget = new HttpGet(url);
		    
		    //设置请求和传输超时时间，单位毫秒
		    RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
		    httpget.setConfig(requestConfig);
		    
		    // 执行get请求.                                                                                    
		    CloseableHttpResponse response = httpclient.execute(httpget);                                     
		    try {                                                                                              
		        // 获取响应实体                                                                                
		        HttpEntity entity = response.getEntity();                                                      
		        // 获取响应状态                                                                                
		        int status = response.getStatusLine().getStatusCode();
		        if (status == 200) {//能够正常响应
		        	rtn = EntityUtils.toString(entity,charset);
		        } else {//访问出现问题
		        	rtn = String.valueOf(status);
		        }
		                                     
		    } finally {                                                                                        
		        response.close();                                                                              
		    }                                                                                                  
		} catch (Exception e) {
			rtn = "timeout";
		    e.printStackTrace();                                                                               
		                                                                         
		} finally {                                                                                            
		    // 关闭连接,释放资源                                                                               
		    try {                                                                                              
		        httpclient.close();                                                                            
		    } catch (IOException e) {                                                                          
		        e.printStackTrace();                                                                           
		    }                                                                                                  
		}                                                                                                      

		return rtn;

	}
	/**
	 * 执行doPost操作，默认采用UTF-8编码获得数据流,默认超时时间为5分钟
	 * @param url 访问URL地址
	 * @param param 需要传递的参数和值<br>
	 * 示例：<br>
	 * Map<String,Object> param = new HashMap<String,Object>();<br>
	 * param.put("name", "中文");<br>
	 * param.put("pwd", "1qaz");	 	 
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String  doPost(String url,Map<String,Object> param) {
		return doPost(url,"UTF-8",param,1000*60*5);
	}
	
	public static String  doPost(String url,String jsonParam) {
		return doPost(url,"UTF-8",jsonParam,1000*60*5);
	}
	
	/**
	 * 执行doPost操作，默认采用UTF-8编码获得数据流
	 * @param url 访问URL地址
	 * @param param 需要传递的参数和值<br>
	 * @param timeout 设置超时时间，单位毫秒
	 * 示例：<br>
	 * Map<String,Object> param = new HashMap<String,Object>();<br>
	 * param.put("name", "中文");<br>
	 * param.put("pwd", "1qaz");	 	 
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */
	public static String  doPost(String url,Map<String,Object> param,Integer timeout) {
		return doPost(url,"UTF-8",param,timeout);
	}
	
	/**
	 * 执行doPost操作
	 * @param url 访问URL地址
	 * @param charset 参数和获得数据流编码
	 * @param param 需要传递的参数和值<br>
	 * @param timeout 设置超时时间，单位毫秒
	 * 示例：<br>
	 * Map<String,Object> param = new HashMap<String,Object>();<br>
	 * param.put("name", "中文");<br>
	 * param.put("pwd", "1qaz");	 
	 * @return 访问url的返回数据流值<br>
	 * 		   1.访问状态为200时：返回正常值<br>
	 * 		   2.访问状态非200时，如400，500时，返回访问状态值<br>
	 * 		   3.连接超时时，返回timeout
	 */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
	public static String  doPost(String url,String charset,Map<String,Object> param,Integer timeout) {		
		String rtn = "";
	    // 创建默认的httpClient实例.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
	    CloseableHttpClient httpclient = HttpClients.createDefault();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
	    // 创建httppost                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	    HttpPost httppost = new HttpPost(url); 
	    //设置请求和传输超时时间，单位毫秒
	    RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
	    httppost.setConfig(requestConfig);
	    // 创建参数队列                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	    List<NameValuePair> formparams = new ArrayList<NameValuePair>();
	    //循环放入参数
	    for (Map.Entry<String, Object> entry : param.entrySet()) {
	        String key = entry.getKey().toString();//key值
	        String value = entry.getValue().toString();//value值
	        formparams.add(new BasicNameValuePair(key, value)); 
	    }
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
	    UrlEncodedFormEntity uefEntity;//编码后的参数                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	    try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	        uefEntity = new UrlEncodedFormEntity(formparams, charset);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
	        httppost.setEntity(uefEntity);
	        //执行后的返回值
	        CloseableHttpResponse response = httpclient.execute(httppost);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
	        try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	            HttpEntity entity = response.getEntity();//返回entity                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
	            int status = response.getStatusLine().getStatusCode();//返回状态
		        if (status == 200) {//访问正常
		        	rtn = EntityUtils.toString(entity,charset);
		        } else {//访问出错
		        	rtn = String.valueOf(status);
		        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
	        } finally {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	            response.close();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	    } catch (Exception e) {
	    	rtn = "timeout";
	        e.printStackTrace();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
	    } finally {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
	        // 关闭连接,释放资源                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
	        try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	            httpclient.close();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
	        } catch (IOException e) {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
	            e.printStackTrace();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
	        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	    }
	    return rtn;
	}
	
	public static String  doPost(String url,String charset,String jsonParam,Integer timeout) {	
		String rtn = "";
	    // 创建默认的httpClient实例.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
	    CloseableHttpClient httpclient = HttpClients.createDefault();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
	    // 创建httppost                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	    HttpPost httppost = new HttpPost(url); 
	    //设置请求和传输超时时间，单位毫秒
	    RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
	    httppost.setConfig(requestConfig);
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
	    StringEntity stringEntity;//编码后的参数                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	    try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	        stringEntity = new StringEntity(jsonParam,charset);
            stringEntity.setContentEncoding(charset);
            stringEntity.setContentType("application/json");
	        httppost.setEntity(stringEntity);
	        //执行后的返回值
	        CloseableHttpResponse response = httpclient.execute(httppost);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
	        try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	            HttpEntity entity = response.getEntity();//返回entity                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
	            int status = response.getStatusLine().getStatusCode();//返回状态
		        if (status == 200) {//访问正常
		        	rtn = EntityUtils.toString(entity,charset);
		        } else {//访问出错
		        	rtn = String.valueOf(status);
		        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
	        } finally {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
	            response.close();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	    } catch (Exception e) {
	    	rtn = "timeout";
	        e.printStackTrace();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
	    } finally {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
	        // 关闭连接,释放资源                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
	        try {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
	            httpclient.close();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
	        } catch (IOException e) {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
	            e.printStackTrace();                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
	        }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	    }
	    return rtn;
	}
	
	/**
	 * 格式化URL，将"//"替换为"/"
	 * @param url 
	 * @return 格式化后的URL
	 */
	public static String formatURL(String url) {
		if (StringUtil.isNullorEmptyStr(url)) {
			return url;
		}
		String tmpURL = url.toLowerCase();
		if (tmpURL.indexOf("http://") != -1) {
			url = "http://" + url.substring(tmpURL.indexOf("http://")+7).replaceAll("//", "/");
		} else if (tmpURL.indexOf("https://") != -1) {
			url = "https://" + url.substring(tmpURL.indexOf("https://")+8).replaceAll("//", "/");
		} else {
			url = url.replaceAll("//", "/");
			url = url.replaceAll("//", "/");
			url = url.replaceAll("//", "/");
		}
		return url;
	}

	/**
	 * 
	 * @param url 需要生成静态页面的全路径URL，如：http://www.peaktele.com/lms/login.jsp
	 * @param endmark 生成文件的结束标志，为了保证生成文件完整，方法会判断是否发现结束标识字符串，尽量命名特殊点防止实际内容中包含此字符串
	 * @param filename 生成的静态文件的文件名，包含全路径，如：d:\resource\firstpage\homeportal.html
	 * @param isHttps 是否生成https静态文件，true:生成https静态文件，false:不生成https静态文件
	 * <br/>生成https静态文件,文件名为原文件名加_s，如：d:\resource\firstpage\homeportal_s.html
	 * @return 是否生成成功，true:成功，false:失败
	 * @throws Exception 
	 */
	public static boolean  generateHTMLPage(String url,String endmark, String filename, Boolean isHttps) throws Exception {
		
		//FileWriter fw = null;
		OutputStreamWriter fw = null;
		boolean rtn = true;
		try {
			
			// 获取URL内容
			String htmlStr = doGet(url);			
			if (htmlStr.indexOf(endmark) != -1) {//获得URL成功，重新生成静态文件
				// 1、index.html
				String filepath = filename.substring(0, filename.lastIndexOf("."));
				//weizhenyong add---如果目录不存在自动创建
				String fp= filepath.substring(0, filename.lastIndexOf("/"));
				File f = new File(fp);
				//判断下发课程存储目录是否存在如果不存在，创建目录
				if (!f.exists()) {
					f.mkdirs();
				}
				String dateTimeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
				String newFileName = filepath + "_" + dateTimeStr + ".html";// 新文件名
				String fileNameBak = filepath + "_" + dateTimeStr + "_bak.html";// 原文件备份名称

				
				// 生成新index文件,如index_20130911160100.html
				//使用FileWriter如果系统默认编码不是utf-8,会造成html页面访问乱码
				//fw = new FileWriter(newFileName);
				fw = new OutputStreamWriter(new FileOutputStream(newFileName), "UTF-8");
				fw.write(htmlStr);
				fw.flush();
				fw.close();
				// 新文件替换原文件
				renameFile(filename, newFileName, fileNameBak);// http
				//https文件生成
				if (isHttps) {
					// 2、indexhttps.html
					String fileNameHttps = filepath + "_s.html";// 原文件名(https:)
					String newFileNameHttps = filepath + "_s_" + dateTimeStr + ".html";// 新文件(https:)
					String fileNameBakHttps = filepath + "_s_" + dateTimeStr + "_bak.html";// 原文件备份名称(https:)
					// 生成新indexhttps文件,如indexhttps_20130911160100.html
					htmlStr = htmlStr.replaceAll("http:", "https:");//https协议时，登录前页面中的http转成https,因为抓取路径是内网地址，https下出现不安全提示
					htmlStr = htmlStr.replaceAll("HTTP:", "https:");//大写HTTP也替换为https
					
					//下面两行不替换，替换后页面不能正常显示
					htmlStr = htmlStr.replace("https://www.w3.org/TR/html4/loose.dtd", "http://www.w3.org/TR/html4/loose.dtd");
					htmlStr = htmlStr.replace("https://www.w3.org/1999/xhtml", "http://www.w3.org/1999/xhtml");
					
					//使用FileWriter如果系统默认编码不是utf-8,会造成html页面访问乱码
					//fw = new FileWriter(newFileNameHttps);
					fw = new OutputStreamWriter(new FileOutputStream(newFileNameHttps),"UTF-8");
					fw.write(htmlStr);
					fw.flush();
					fw.close();
					htmlStr = null;			
					renameFile(fileNameHttps, newFileNameHttps, fileNameBakHttps);// https
				}
			}
			
		} catch (Exception e) {
			rtn = false;
			e.printStackTrace();			
		} finally {
			if (fw != null) {
				fw.close();
				fw = null;
			}
		}
		return rtn;
	}
	
	/**
	 * 重命名文件名
	 * @param oldFileName 老的文件名
	 * @param newFileName 新文件名
	 * @param oldfileNameBak 老文件备份名
	 * @throws Exception
	 */
	public static void renameFile(String oldFileName, String newFileName, String oldfileNameBak) throws Exception {
			// 读取新html文件内容
			File newFile = new File(newFileName);
			File oldFile = new File(oldFileName);
			File oldfileBak = new File(oldfileNameBak);
			if (oldFile.exists() && oldFile.isFile()) {
				oldFile.renameTo(oldfileBak);
			}
			// 新生成的文件index_20130911160100.html重命名为index.html
			newFile.renameTo(oldFile);
			// 删除备份文件index_20130911160100_bak.html
			oldfileBak.delete();
	}
	
	 public final static void main(String[] args) throws Exception {
//		 doGet("http://localhost/t.htm");
		 Map<String,Object> param = new HashMap<String,Object>();
		 param.put("name", "中文");
		 param.put("pwd", "1qaz");
	 }

}
