package com.peak.common.util;

import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.exception.PrdBaseException;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;

/**
 * 工具类
 * @author zhangdexin
 *
 */
public class IdUtil {
	
	/**
	 * 通过循环列表，抽取id属性，返回ids，过滤掉null元素
	 * @param list 任意列表
	 * @param func lambda表达式：以Lesson举例：e->e.getLessonId()
	 * @return id列表
	 */
	public static <T, R> List<R> getIds(List<T> list, Function<T, R> func) {
		if (list == null || list.isEmpty()) return new ArrayList<>();
		
		List<R> ids = new ArrayList<>();
		R tmp;
		for (int i=0; i<list.size(); i++) {
			tmp = func.apply(list.get(i));
			//过滤掉null元素
			if (tmp == null) {
				continue;
			}
			ids.add(tmp);
		}
		return ids;
	}
	
	/**
	 * 解析分割字符串为id列表
	 * @param str
	 * @param regexSplitor 分隔符
	 * @return
	 */
	public static List<Long> getIds(String str, String regexSplitor) {
		if (str == null || str.isEmpty() || regexSplitor == null || regexSplitor.isEmpty()) return new ArrayList<Long>();
		
		List<Long> ids = new ArrayList<Long>();
		String[] ary = str.split(regexSplitor);
		for (int i=0; ary!=null && i<ary.length; i++) {
			if (ary[i] == null || ary[i].isEmpty() || ary[i].trim().isEmpty()) continue;
			ids.add(new Long(ary[i]));
		}
		return ids;
	}
	
	/**
	 * 
	 * 将list中的id转化为字符串，字符串之间采用separator分隔
	 * @param list 源list
	 * @param separator id字符串之间的分隔符
	 * @param func lambda表达式：以Lesson举例：e->e.getLessonId()
	 * @return 示例：1000 1001 ，开头和结尾都没有空格，list为空时返回""
	 * @author wzy
	 * @CreateDate 2022年2月9日
	 *
	 */
	public static <T> String getIdStrs(List<T> list,String separator, Function<T, Long> func) {
		if (list == null || list.isEmpty()) return "";
		StringBuilder sb = new StringBuilder();
		for (int i=0; i<list.size(); i++) {
			if (i > 0) {//第一个无需拼接
				sb.append(separator);
			}
			sb.append(func.apply(list.get(i)) );
		}
		return sb.toString();
	}
	
	/**
	 * 返回一个新gkey
	 * @return
	 */
	public static String getGkey() {
		return UUID.randomUUID().toString().replaceAll("-", "");
	}
	
	/**
	 * 返回一个新主键值
	 * @param tableName
	 * @return
	 */
	public static Long getSequence(String tableName) {
		try {
			return IPrimaryKey.DEFAULT.getSequence(tableName);
		} 
		catch (SQLException e) {
			throw new PrdBaseException("getPrimaryKey error", e);
		}
	}
}
