package com.peak.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.util.List;

/**
 * json 操作类
 * @author peaktele
 *
 */
public class JsonUtil {
	
	/**
	 * 将对象转换成json字符串，支持普通对象和list，日期格式："yyyy-MM-dd HH:mm:ss"，具有null属性
	 * @param obj 待转化的对象，支持普通对象和list
	 * @return
	 * @author wzy
	 * @CreateDate 2021年12月17日
	 *
	 */
	public static String  objectToJson(Object obj) {
		JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss" ;
		return JSON.toJSONString(obj, SerializerFeature.WRITE_MAP_NULL_FEATURES, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteDateUseDateFormat);
	}
	
	/**
	 * <p>将对象转换成ES需要的json字符串，支持普通对象和list，日期格式："yyyy-MM-ddTHH:mm:ss"，具有null属性</p>
	 * @param obj  待转化的对象，支持普通对象和list
	 * @return String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2022年1月6日 下午9:21:17 </p>
	 */
	public static String  objectToESJson(Object obj) {
		JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss" ;
		return JSON.toJSONString(obj);
	}
	
	/**
	 * 将json字符串转化为对象
	 * @param <T>
	 * @param json json字符串
	 * @param clazz 需要转换为的对象
	 * @return
	 * @author wzy
	 * @CreateDate 2021年12月17日
	 *
	 */
	public static <T>  T JsonToObject(String json, Class<T> clazz) {
		return JSON.parseObject(json, clazz);
	}
	
	/**
	 * 将json字符串数组转换成对象list
	 * @param jsonArray
	 * @param clazz 需要转换为的对象
	 * @return
	 * @author wzy
	 * @CreateDate 2021年12月17日
	 *
	 */
	public static <T> List<T>  JsonToList(String jsonArray, Class<T> clazz) {
		return JSON.parseArray(jsonArray, clazz);
	}
	
	
	
}
