/**
 * 功能描述: 网络信息操作相关工具类
 * @author 魏振永
 * @version 1.0
 * @since 1.0   - 2014-8-6 
 */
package com.peak.common.util;

import javax.servlet.http.HttpServletRequest;
import java.net.Inet4Address;




public class NetworkUtil {
	/**
     * 获取客户端IP地址
     * @param request 请求流
     * @return 访问服务器的客户端IP
     * */
	public static String getClientIp(HttpServletRequest request) {
		String ip = request.getHeader("Peak_Client_IP");
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("X-Forwarded-For");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("HTTP_CLIENT_IP");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getHeader("x-clientip");
		}
		if ((ip == null) || (ip.length() == 0) || ("unknown".equalsIgnoreCase(ip))) {
			ip = request.getRemoteAddr();
		}
		if ((ip != null) && (ip.trim().equals("127.0.0.1"))) {
			try {
				ip = Inet4Address.getLocalHost().getHostAddress();
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		//有的客户网络系统会回传多个IP，IP间采用逗号分隔，系统截取第一个IP做为客户端真实IP
		if (ip != null ) {
			//中文逗号修改为英文逗号
			ip = ip.replaceAll("，",",");
			//存在多个Ip
			if (ip.contains(",")) {
				ip = ip.substring(0,ip.indexOf(","));
			}
		}
		return ip;
	}

//	public static void main(String[] args) {
//		String ip = "192.168.1.265";
//		if (ip != null ) {
//			//中文逗号修改为英文逗号
//			ip = ip.replaceAll("，",",");
//			if (ip.contains(",")) {
//				int pos = ip.indexOf(",");
//				ip = ip.substring(0,pos);
//			}
//		}
//	}
    
    /**
	 *  检测一个IP是否在一个IP范围段内,*表示从0-255
	 * @param originIP 待检测的IP地址
	 * @param startIP IP范围段的起始IP地址
	 * @param endIP IP范围段的结束IP地址
	 * @return true 包含，false 不包含
	 */
	public static boolean isContainIP(String originIP,String startIP, String endIP)
	{
		boolean rtn = false;//返回值，默认为false
		String[] arrayOriginIP = originIP.split("\\.");//待检测IP地址数组
		String[] arrayStartIP = startIP.split("\\.");//起始IP地址数组
		String[] arrayEndIP = endIP.split("\\.");//结束IP地址数组
		int ip = 0;//每一段IP地址，IP地址分为4段
		int start = 0;//每一段IP地址起始
		int end = 0;//每一段IP地址结束	
		int pos = -1;//包含位置
		//IP地址是IP V4的
		if ((arrayOriginIP.length == 4)&& (arrayStartIP.length == 4)&&(arrayEndIP.length == 4))
		{
			//循环检测每一个段IP地址
			for (int i=0; i<arrayOriginIP.length; i++)
			{
				ip = Integer.parseInt(arrayOriginIP[i]);
				//将起始*转换为0，IP地址最小值，从而判断是否包含
				if (arrayStartIP[i].equals("*"))
				{
					arrayStartIP[i] = "0";
				}
				//将结束*转换为255，IP地址最大值，从而判断是否包含
				if (arrayEndIP[i].equals("*"))
				{
					arrayEndIP[i] = "255";
				}
				start = Integer.parseInt(arrayStartIP[i]);
				end = Integer.parseInt(arrayEndIP[i]);
				if ((ip>=start) && (ip<=end))//在范围内
				{
					pos = i;					
				}
				else//不在范围内
				{
					break;
				}
			}
		}
		if (pos == 3) {//表示包含IP
			rtn = true;
		}
		return rtn;
		
	}
	

	
	
}
