package com.peak.common.util;

import java.io.File;
import java.nio.charset.Charset;

/**
 * 获得操作系统相关信息
 * @author wzy
 * @date 2023/7/31 22:28
 */
public class OSUtil {
    /**
     * 判断是否为windows系统
     *
     * @return boolean true：windows系统，false：其他系统
     * @author wzy
     * @date 2023/7/31 22:28
     */
    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }
    /**
     * 获得系统字符集，windows返回GBK，其他的返回UTF-8
     * @return windows返回GBK，其他的返回UTF-8
     * @author wzy
     * @date 2023/7/31 22:33
     */
    public static Charset getSysCharset() {
        return isWindows() ? Charset.forName("GBK") : Charset.forName("UTF-8");
    }
}