package com.peak.common.util;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;


/**
 * Ognl工具类，主要是为了在ognl表达式访问静态方法时可以减少长长的类名称编写
 * Ognl访问静态方法的表达式为: @class@method(args)
 * 
 * 示例使用: 
 * <pre>
 * 	&lt;if test="@Ognl@isNotEmpty(userId)">
 *		and user_id = #{userId}
 *	&lt;/if>
 * </pre>
 * @author badqiu
 *
 */

/**
 * springboot的mybatis mapper中，不可以使用没有package的类
 * 因此，这里copy了原始Ognl代码，增加了package
 * @author zhangdexin
 */
public class OgnlUtil {
	
		/**
		 * 可以用于判断String,Map,Collection,Array是否为空
		 * @param o
		 * @return 
		 */
		public static boolean isEmpty(Object o) throws IllegalArgumentException {
			if(o == null) return true;

			if(o instanceof String) {
				if(((String)o).length() == 0){
					return true;
				}
			} else if(o instanceof Collection) {
				if(((Collection)o).isEmpty()){
					return true;
				}
			} else if(o.getClass().isArray()) {
				if(Array.getLength(o) == 0){
					return true;
				}
			} else if(o instanceof Map) {
				if(((Map)o).isEmpty()){
					return true;
				}
			}else {
				return false;
//				throw new IllegalArgumentException("Illegal argument type,must be : Map,Collection,Array,String. but was:"+o.getClass());
			}

			return false;
		}
		/**
		 * 可以用于判断 Map,Collection,String,Array是否不为空
		 * @param c
		 * @return
		 */	
		public static boolean isNotEmpty(Object o) {
			return !isEmpty(o);
		}
		public static boolean isNotEmpty(Object o,Object o2) {
			return !isEmpty(o)||!isEmpty(o2);
		}
		public static boolean isNotBlank(Object o) {
			return !isBlank(o);
		}
		
		public static boolean isNumber(Object o) {
			if(o == null) return false;
			if(o instanceof Number) {
				return true;
			}
			if(o instanceof String) {
				String str = (String)o;
				if(str.length() == 0) return false;
				if(str.trim().length() == 0) return false;
				
				try {
					Double.parseDouble(str);
					return true;
				}catch(NumberFormatException e) {
					return false;
				}
			}
			return false;
		}
		
		public static boolean isBlank(Object o) {
			if(o == null)
				return true;
			if(o instanceof String) {
				String str = (String)o;
				return isBlank(str);
			}
			return false;
		}
		public static boolean isNotZero(Object o) {
			if(o == null)
				return false;
			
			return 0!=Integer.parseInt(o.toString());
		}
		public static boolean isBlank(String str) {
			if(str == null || str.length() == 0) {
				return true;
			}
			
			for (int i = 0; i < str.length(); i++) {
				if (!Character.isWhitespace(str.charAt(i))) {
					return false;
				}
			}
			return true;
		}
		public static boolean equal(Object str,Object str2) {
			if(str == null || str2 == null) {
				return false;
			}
			if(str.equals(str2)){
				return true;
			}
			if(str.toString().equals(str2.toString())){
				return true;
			}
			return false;
		}
		public static boolean equalnew(Object str,Object str2) {
			if(str == null || str2 == null) {
				return false;
			}
			if(str.equals(str2)){
				return true;
			}
			if(str.equals(0)){
				str = false;
			}else if(str.equals(1)){
				str = true;
			}
			if(str2.equals(0)){
				str2 = false;
			}else if(str2.equals(1)){
				str2 = true;
			}
			if(str.toString().equals(str2.toString())){
				return true;
			}
			return false;
		}
		/**
		 * 
		* @Description: 得到一个对象前，判断其是否为空，如果为空给出缺省值
		* @param <T>
		* @param value
		* @param defaultValue
		* @return
		* @return T
		* @throws
		 */
		public static <T>  T getValue(T value,T defaultValue)
		{
			return value==null?defaultValue:value;
		}

		/**
		 *@Description: mybatis获取原始字面量，过滤了
		* @param <T>
		 */
		public static String   strv (Object value)
		{
		   return value.toString();
		}
//		public static String   getHtml (String value)
//		{
//			return StringEscapeUtils.unescapeHtml(value);
//		}
		

	}

