package com.peak.common.util;

import org.springframework.security.crypto.bcrypt.BCrypt;

import com.peak.prd.config.AppCommonConfig;
/**
 * 密码加密工具类
 * @author weizhenyong
 * 
 * 2023/5/29 增加SM3算法支持
 * 用户表的密码字段，需要用PWDUtil.encrypt(明文)加密存储
 * 并且，算法appcommon.prperties中，需要设置：
 * pwd.encode.algorithm=SM3
 *
 */
public class PWDUtil {
	
	private static byte[] sm3key = "45d52d6e58701e57".getBytes();
	
	/**
	 * 对密码进行加密
	 * @param originpwd 原始密码未经加密过的密码
	 * @return 加密后的密码
	 * @author wzy
	 * @CreateDate 2022年1月22日
	 *
	 */
	public static String encrypt(String originpwd) {
		String algorithm = getPwdAlgorithm();
		if (algorithm.trim().equalsIgnoreCase("MD5")) {
			return MD5Util.md5Encode(originpwd);
		}
		else if (algorithm.trim().equalsIgnoreCase("SM3")) {
			return Sm3Util.hmacToString(sm3key, originpwd);
		}
		else {
			return BCrypt.hashpw(originpwd, BCrypt.gensalt());
		}
		
	}

	
	
	/**
	 * 检查未加密的原始密码和加密密码是否匹配
	 * @param originpwd 未加密的原始密码
	 * @param encryptpwd 加密后的密码
	 * @return true: 匹配，false:不匹配
	 * @author wzy
	 * @CreateDate 2022年1月22日
	 *
	 */
	public static boolean checkPwd(String originpwd, String encryptpwd) {		
		String algorithm = getPwdAlgorithm();
		if (algorithm.trim().equalsIgnoreCase("MD5")) {
			return MD5Util.md5Encode(originpwd).equals(encryptpwd);
		}
		else if (algorithm.trim().equalsIgnoreCase("SM3")) {
			return Sm3Util.hmacToString(sm3key, originpwd).equals(encryptpwd);
		}
		else {
			return BCrypt.checkpw(originpwd, encryptpwd);
		}
	}
	
	/**
	 * 获得登录密码加密规则
	 * @return 加密规则
	 * @author wzy
	 * @CreateDate 2022年1月22日
	 *
	 */
	private static String getPwdAlgorithm() {
		AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
		String algorithm = config.getPwdEncodeAlgorithm();
		if (StringUtil.isNullorEmptyStr(algorithm)) {
			algorithm = "BCrypt";
		}
		return algorithm;
	}
	

	public static void main(String[] args) {
		String pwd = "Fish200212abcd";
//		String encryptpwd  = encrypt(pwd);
//		String encryptpwd  = "$2a$10$dwZQEZav.AU5bwoiqux79OxuEIG14S.gZcFmCLObVhHfAMfg7GA.i";
		String encryptpwd  = "$2a$10$HoqutL2Az8XiUnMOgarVN.GQ5IBfvuSZQBhAEgqQ7xLT4sgc4bTVC";
		boolean rtn = checkPwd(pwd,encryptpwd);

	}
	
	
	
}
