package com.peak.common.util;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.peak.prd.config.RedisConfig;

@Component
public class RedisHashService {
	
	@Autowired
	private StringRedisTemplate redisTemplate;
	
	@Autowired
	RedisConfig redisConfig;
	
	// 附加前缀
	String getKey(String key) {
		String prefix = redisConfig.getKeyPrefix();
		if (prefix == null) return key;
		
		return prefix + "::" + key;
	}
	
	List<String> getKeys(List<String> keys) {
		String prefix = redisConfig.getKeyPrefix();
		if (prefix == null || keys == null) return keys;
		
		List<String> newKeys = new java.util.ArrayList<String>();
		for (int i=0; i<keys.size(); i++) {
			newKeys.add(prefix + "::" + keys.get(i));
		}
		
		return newKeys;
	}
	
//	@Autowired
//	public RedisHashService(StringRedisTemplate redisTemplate) {
//		RedisSerializer<String> stringSerializer = new StringRedisSerializer();
//        redisTemplate.setKeySerializer(stringSerializer);
//        redisTemplate.setValueSerializer(stringSerializer);
//        redisTemplate.setHashKeySerializer(stringSerializer);
//        redisTemplate.setHashValueSerializer(stringSerializer);
//        this.redisTemplate = redisTemplate;
//	}
	
	public void put(String key, String hashKey, Object hashValue) {
		redisTemplate.opsForHash().put(this.getKey(key), hashKey, hashValue);
	}
	
	public void put(String key, String hashKey, Object hashValue, long secondsTimeout) {
		redisTemplate.opsForHash().put(this.getKey(key), hashKey, hashValue);
		redisTemplate.expire(this.getKey(key), secondsTimeout, TimeUnit.SECONDS);
	}
	
	public Object get(String key, String hashKey) {
		return redisTemplate.opsForHash().get(this.getKey(key), hashKey);	
	}
	
	/**
	 * 实现命令：expire 设置过期时间，单位秒
	 * 
	 * @param key
	 * @return
	 */
	public void expire(String key, long timeout) {
		redisTemplate.expire(this.getKey(key), timeout, TimeUnit.SECONDS);
	}
	
	/**
	 * 实现命令：DEL key，删除一个key
	 * 
	 * @param key
	 */
	public void del(String key) {
		redisTemplate.delete(this.getKey(key));
	}
}
