package com.peak.common.util;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
/**
 * <p>redis消息发送服务类</p>
 * <p>2021年11月16日 下午5:29:25</p>
 * <p>Copyright：北京尖峰合讯科技有限公司 2021 </p>
 * @author <a href=zhangkai@peaktele.com>张恺</a>
 * @version 1.0.0
 * @since  1.0.0
 */
@Component
public class RedisMqService {
	@Autowired
	private StringRedisTemplate redisTemplate;
	
	/**
	 * <p>发送消息</p>
	 * @param topic 消息主题
	 * @param message 消息体
	 * @since   1.0.0
	 * @author zhk
	 * @date 2021年11月17日 下午3:12:29 </p>
	 */
	public void send(String topic, Object message) {
		redisTemplate.convertAndSend(topic, message);
	}
	
}
