package com.peak.common.util;

import com.peak.prd.config.RedisConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.*;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.stereotype.Component;

import java.util.List;
/**
 * <p>redis5.0以上redisStream消息发送服务类</p>
 * <p>2021年11月16日 下午5:29:25</p>
 * <p>Copyright：北京尖峰合讯科技有限公司 2021 </p>
 * @author <a href=zhangkai@peaktele.com>张恺</a>
 * @version 1.0.0
 * @since  1.0.0
 */
@Component
public class RedisStreamService {
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	
	@Autowired
	RedisConfig redisConfig;
	
	// 附加前缀
	String getKey(String key) {
		String prefix = redisConfig.getKeyPrefix();
		if (prefix == null) return "MQ:"+key;
		
		return prefix + "::MQ:" + key;
	}
	
	/*@Autowired
	public RedisStreamService(RedisTemplate<String, Object> redisTemplate) {
		RedisSerializer<String> stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer(stringSerializer);
        redisTemplate.setValueSerializer(stringSerializer);
        redisTemplate.setHashKeySerializer(stringSerializer);
        redisTemplate.setHashValueSerializer(stringSerializer);
        this.redisTemplate = redisTemplate;
	}*/
	
	/**
	 * <p>发送消息</p>
	 * @param topic 消息主题
	 * @param message 消息体
	 * @since   1.0.0
	 * @author zhk
	 * @date 2021年11月17日 下午3:12:29 </p>
	 */
	public RecordId send(String topic, Object message) {
		topic = getKey(topic);
		Record<String, Object> record = StreamRecords.objectBacked(message).withStreamKey(topic);
	    return redisTemplate.opsForStream().add(record);
	}
	
	public void addGroup(String topic, String groupName){
		topic = getKey(topic);
        redisTemplate.opsForStream().createGroup(topic,groupName);
    }

    public void delRecord(String topic, String recordId){
    	topic = getKey(topic);
        redisTemplate.opsForStream().delete(topic,recordId);
    }
    
    public boolean hasStream(String topic){
    	topic = getKey(topic);
        Boolean aBoolean = redisTemplate.hasKey(topic);
        return aBoolean==null?false:aBoolean;
    }
    
    public StreamInfo.XInfoGroups getGroups(String topic){
    	topic = getKey(topic);
    	StreamInfo.XInfoGroups infoGroups = null;
        try {
            // 获取Stream的所有组信息
            infoGroups = redisTemplate.opsForStream().groups(topic);
        } catch (Exception ex) {
            return null;
        }
        return infoGroups;
    }

    public void createGroup(String topic,String groupId){
    	topic = getKey(topic);
    	redisTemplate.opsForStream().createGroup(topic, groupId);
    }

    public void destroyGroup(String topic,String groupId){
        topic = getKey(topic);
        redisTemplate.opsForStream().destroyGroup(topic, groupId);
    }

    public List<MapRecord<String,Object,Object>> getAllStream(String key){
    	key = getKey(key);
        List<MapRecord<String, Object, Object>> range = redisTemplate.opsForStream().range(key, Range.open("-", "+"));
        if(range == null){
            return null;
        }
        for(MapRecord<String,Object,Object> mapRecord : range){
            redisTemplate.opsForStream().delete(key,mapRecord.getId());
        }
        return range;
    }
    
    public StreamOperations<String, String, String> opsForStream(){
        return redisTemplate.opsForStream();
       
    }


    public Long getStreamSize(String key) {
        return redisTemplate.opsForStream().size( this.getKey(key) );
    }

    public void trim(String key, long currLen) {
        redisTemplate.opsForStream().trim(this.getKey(key), currLen);
    }

    public RedisConnectionFactory getConnectionFactory(){
        return redisTemplate.getConnectionFactory();
    }


    public MapRecord<String,Object,Object> getRecord(String key, String recordId){
        key = getKey(key);
        List<MapRecord<String, Object, Object>> ranges = redisTemplate.opsForStream().range(key, Range.open(recordId, recordId));
        if(ranges == null){
            return null;
        }

        return ranges.get(0);
    }
}

