package com.peak.common.util;

import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.config.AppCommonConfig;

import java.util.Arrays;
import java.util.List;
import lombok.extern.slf4j.Slf4j;

/**
 * 各种安全校验工具
 * @author wzy
 * @date 2023/8/21 21:21
 */
@Slf4j
public class SecurityUtil {
    /**
     * 是否是系统允许的上传、下载文件扩展名
     * @param filename 文件名，如果为null，返回false
     * @return  true：允许；false：不允许；
     * @author wzy
     * @date 2023/8/21 22:30
     */
    public static boolean isAllowFileext(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String allowedExtensions = config.getUploadfileAllowedExtensions().toLowerCase();
        String[] allowedExtArray = allowedExtensions.split(",");
        List<String> allowedExtList = Arrays.asList(allowedExtArray);
//		在允许的文件白名单之内的文件类型
        if (allowedExtList.contains(fileExtention)) {
            return true;
        }
        return false;
    }
    /**
     * 是否是系统允许的上传、下载图片扩展名
     * @param filename 文件名，如果为null，返回false
     * @return  true：允许；false：不允许；
     * @author wzy
     * @date 2023/8/21 22:41
     */
    public static boolean isAllowImgext(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String allowedImgExtensions = config.getUploadfileImgAllowedExtensions().toLowerCase();
        String[] allowedExtArray = allowedImgExtensions.split(",");
        List<String> allowedExtList = Arrays.asList(allowedExtArray);
//		在允许的图片文件白名单之内的文件类型
        if (allowedExtList.contains(fileExtention)) {
            return true;
        }
        return false;
    }
    /**
     * 获取是否是系统允许的上传的文件尺寸，不用的文件类型，允许上传不同的尺寸
     * @param filename 上传文件名
     * @param filesize 上传文件尺寸，单位：字节
     * @return boolean true：允许上传；false：不允许上传
     * @author weizhenyong
     * @date 2024/9/29 22:19
     */
    public static boolean isAllowUploadSize(String filename,Long filesize) {
//        log.info("isAllowUploadSize====filename================"+filename+"filesize================="+filesize);
        if (filename == null || filesize == null) {
            return false;
        }

        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);

        if (isImgFie(filename)) {
            //图片文件
            Integer allowImgSize = config.getUploadfileImgAllowedSizeKB();
            long allowImgSizeLong = allowImgSize.longValue();
            allowImgSizeLong = allowImgSizeLong * 1024;
//            log.info("allowImgSize=============="+allowImgSize);
            if (filesize.longValue() > allowImgSizeLong) {
                return false;
            }
            return true;
        } else if (isVideoFie(filename)) {
            //图片文件
            Integer allowVideoSize = config.getUploadfileVideoAllowedSizeMB();
            long allowVideoSizeLong = allowVideoSize.longValue();
//            log.info("allowVideoSize=====1========="+allowVideoSizeLong);
            allowVideoSizeLong = allowVideoSizeLong * 1024 * 1024;
//            log.info("allowVideoSize=====2========="+allowVideoSizeLong);
//            log.info("allowVideoSize=====333========="+(filesize.longValue() > allowVideoSizeLong));
            if (filesize.longValue() > allowVideoSizeLong) {
                return false;
            }
            return true;
        } else if (isAudioFie(filename)) {
            //图片文件
            Integer allowAudioSize = config.getUploadfileAudioAllowedSizeMB();
            long allowAudioSizeLong = allowAudioSize.longValue();
            allowAudioSizeLong = allowAudioSizeLong * 1024 * 1024;
            if (filesize.longValue() > allowAudioSizeLong) {
                return false;
            }
            return true;
        } else if (isDocFie(filename)) {
            //图片文件
            Integer allowDocSize = config.getUploadfileDocAllowedSizeMB();
            long allowDocSizeLong = allowDocSize.longValue();
            allowDocSizeLong = allowDocSizeLong * 1024 * 1024;
            if (filesize.longValue() > allowDocSizeLong) {
                return false;
            }
            return true;
        } else if (isZipFie(filename)) {
            //图片文件
            Integer allowZipSize = config.getUploadfileZipAllowedSizeMB();
            long allowZipSizeLong = allowZipSize.longValue();
            allowZipSizeLong = allowZipSizeLong * 1024 * 1024;
            if (filesize.longValue() > allowZipSizeLong) {
                return false;
            }
            return true;
        }
        log.info("========end=====================");
        return false;
    }
    /**
     * 是否为图片文件
     * @param filename 文件名
     * @return boolean true：是图片文件；false：不是图片文件
     * @author weizhenyong
     * @date 2024/9/29 22:46
     */
    private static boolean isImgFie(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String imgExtensions = config.getUploadfileImgExtensions().toLowerCase();
        String[] imgExtensionArray = imgExtensions.split(",");
        List<String> imgExtensionList = Arrays.asList(imgExtensionArray);
//		在图片扩展名包含文件扩展名
        if (imgExtensionList.contains(fileExtention)) {
            return true;
        }
        return false;
    }

    /**
     * 是否为视频文件
     * @param filename 文件名
     * @return boolean true：是视频文件；false：不是视频文件
     * @author weizhenyong
     * @date 2024/9/29 22:46
     */
    private static boolean isVideoFie(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String videoExtensions = config.getUploadfileVideoExtensions().toLowerCase();
        String[] videoExtensionArray = videoExtensions.split(",");
        List<String> videoExtensionList = Arrays.asList(videoExtensionArray);
//		在视频扩展名包含文件扩展名
        if (videoExtensionList.contains(fileExtention)) {
            return true;
        }
        return false;
    }

    /**
     * 是否为音频文件
     * @param filename 文件名
     * @return boolean true：是音频文件；false：不是音频文件
     * @author weizhenyong
     * @date 2024/9/29 22:46
     */
    private static boolean isAudioFie(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String audioExtensions = config.getUploadfileAudioExtensions().toLowerCase();
        String[] audioExtensionArray = audioExtensions.split(",");
        List<String> audioExtensionList = Arrays.asList(audioExtensionArray);
//		在音频扩展名包含文件扩展名
        if (audioExtensionList.contains(fileExtention)) {
            return true;
        }
        return false;
    }

    /**
     * 是否为文档文件
     * @param filename 文件名
     * @return boolean true：是文档文件；false：不是文档文件
     * @author weizhenyong
     * @date 2024/9/29 22:46
     */
    private static boolean isDocFie(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String docExtensions = config.getUploadfileDocExtensions().toLowerCase();
        String[] docExtensionArray = docExtensions.split(",");
        List<String> docExtensionList = Arrays.asList(docExtensionArray);
//		在文档扩展名包含文件扩展名
        if (docExtensionList.contains(fileExtention)) {
            return true;
        }
        return false;
    }

    /**
     * 是否为压缩文件
     * @param filename 文件名
     * @return boolean true：是压缩文件；false：不是压缩文件
     * @author weizhenyong
     * @date 2024/9/29 22:46
     */
    private static boolean isZipFie(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String zipExtensions = config.getUploadfileZipExtensions().toLowerCase();
        String[] zipExtensionArray = zipExtensions.split(",");
        List<String> zipExtensionList = Arrays.asList(zipExtensionArray);
//		在压缩扩展名包含文件扩展名
        if (zipExtensionList.contains(fileExtention)) {
            return true;
        }
        return false;
    }
    /**
     * 检查上传文件是否合法
     * @param filename 文件名
     * @param filesize 文件大小，单位：字节
     * @author weizhenyong
     * @date 2024/9/29 23:04
     */
    public static void checkUploadFilePermission(String filename,Long filesize) {
//		不允许上传白名单之外的文件类型
        if (!SecurityUtil.isAllowFileext(filename)) {
            ExceptionUtil.handle(ResponseStatusEnum.FILE_EXT_ERROR);
        }
        //文件大小是否是系统允许的上传的文件尺寸，不用的文件类型，允许上传不同的尺寸
        if (!SecurityUtil.isAllowUploadSize(filename,filesize)) {
            ExceptionUtil.handle(ResponseStatusEnum.FILE_SIZE_ERROR);
        }


    }
    /**
     * 是否是zip中允许的包含的文件扩展名
     * @param filename 文件名，如果为null，返回false
     * @return  true：允许；false：不允许；
     * @author weizhenyong
     * @date 2024/12/14 16:57
     */
    public static boolean isZipAllowFileext(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtention = FileUtil.getFileExtention(filename).toLowerCase();
        AppCommonConfig config = SpringUtil.getBean(AppCommonConfig.class);
        String allowedExtensions = config.getUploadfileZipAllowedExtensions().toLowerCase();
        //为了兼容原有系统添加相应的配置
        if (StringUtil.isNullorEmptyStr(allowedExtensions)) {
            return true;
        }
        String[] allowedExtArray = allowedExtensions.split(",");
        List<String> allowedExtList = Arrays.asList(allowedExtArray);
//		在允许的文件白名单之内的文件类型
        if (allowedExtList.contains(fileExtention)) {
            return true;
        }
        return false;
    }


}
