package com.peak.common.util;

import com.peak.prd.exception.PrdBaseException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

import java.io.UnsupportedEncodingException;
 

/**
 * 国密工具类 - SM3算法
 * @author zhangdexin
 * https://blog.csdn.net/Genius_zhu/article/details/127120428
 */
public class Sm3Util {
	
//	/**
//     * 计算SM3摘要值
//     *
//     * @param data 原文
//     * @return 摘要值，对于SM3算法来说是32字节
//     */
//    public static byte[] hash(byte[] data) {
//        SM3Digest digest = new SM3Digest();
//        digest.update(data, 0, data.length);
//        byte[] hash = new byte[digest.getDigestSize()];
//        digest.doFinal(hash, 0);
//        return hash;
//    }
// 
//    /**
//     * 验证摘要
//     *
//     * @param srcData 原文
//     * @param sm3Hash 摘要值
//     * @return 返回true标识验证成功，false标识验证失败
//     */
//    public static boolean verify(byte[] srcData, byte[] sm3Hash) {
//        byte[] newHash = hash(srcData);
//        if (Arrays.equals(newHash, sm3Hash)) {
//            return true;
//        } else {
//            return false;
//        }
//    }
 
    /**
     * 计算SM3 Mac值
     *
     * @param key     key值，可以是任意长度的字节数组
     * @param data 原文
     * @return Mac值，对于HMac-SM3来说是32字节
     */
    public static byte[] hmac(byte[] key, byte[] data) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac(digest);
        mac.init(keyParameter);
        mac.update(data, 0, data.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }
    
    /**
     * 加密
     * @param key 密钥
     * @param data 数据
     * @return 加密后的字符串
     */
    public static String hmacToString(byte[] key, String data) {
        byte[] ret;
		try {
			ret = hmac(key, data.getBytes("UTF-8"));
		} 
		catch (UnsupportedEncodingException e) {
			throw new PrdBaseException("", e);
		}
		
        return org.bouncycastle.pqc.math.linearalgebra.ByteUtils.toHexString(ret);
    }
    
//    public static void main(String[] args) throws Exception {
//    	String hexKey = "4e58705d52d61e573329eb4afdf7bb";
//    	String data = "123456123456123456123456123456";
//    	StringBuilder sb = new StringBuilder();
//    	for (int i=0; i<100; i++) {
//    		sb.append(data);
//    	}
//    	String msg = org.bouncycastle.pqc.math.linearalgebra.ByteUtils.toHexString(Sm3Util.hmac(hexKey.getBytes(), sb.toString().getBytes()));
//    }
}

 