package com.peak.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
	
	/**
	 * 将str按照splitor分割成Long列表
	 * @param str
	 * @param splitor
	 * @return 可能返回null
	 */
	public static List<Long> splitToLongList(String str, String splitor) {
		if (str == null || str.isEmpty() || str.trim().isEmpty())
			return null;
		String[] ary = str.split(splitor);
		
		List<Long> list = new ArrayList<Long>();
		
		for (int i=0; i<ary.length; i++) {
			if (ary[i].trim().isEmpty()) {
				continue;
			}
			
			list.add( new Long(ary[i].trim()) );
		}
		
		return list;
	}
	
	public static Long[] splitToLongs(String str, String splitor) {
		
		List<Long> list = splitToLongList(str,splitor);
		if(list==null) 
		return null;
		
		return (Long[]) list.toArray(new Long[list.size()]);
	}
	
	/**
	 * 将str按照splitor分割成Integer列表
	 * @param str
	 * @param splitor
	 * @return 可能返回null
	 */
	public static List<Integer> splitToIntList(String str, String splitor) {
		if (str == null || str.isEmpty() || str.trim().isEmpty())
			return null;
		String[] ary = str.split(splitor);
		
		List<Integer> list = new ArrayList<Integer>();
		
		for (int i=0; i<ary.length; i++) {
			if (ary[i].trim().isEmpty()) {
				continue;
			}
			
			list.add( new Integer(ary[i].trim()) );
		}
		
		return list;
	}
	
	/**
	 * 将str按照splitor分割成String数组
	 * @param str
	 * @param splitor
	 * @return 可能返回null
	 */
	public static String[] splitToStrings(String str, String splitor) {
		if (str == null || str.isEmpty() || str.trim().isEmpty())
			return null;
		return str.split(splitor);
	}
	
	/**
	 * 将str按照splitor分割成String列表,并去掉切割出的空格内容
	 * @param str
	 * @param splitor
	 * @return 可能返回null
	 */
	public static List<String>splitToTrimList(String str, String splitor) {
		if (str == null || str.isEmpty() || str.trim().isEmpty())
			return null;
		String[] ary = str.split(splitor);
		
		List<String> list = new ArrayList<String>();
		
		for (int i=0; i<ary.length; i++) {
			if (ary[i].trim().isEmpty()) {
				continue;
			}
			
			list.add(ary[i].trim());
		}
		
		return list;
	}
	
	/**
	 * 将str按照splitor分割成String数组,并去掉切割出的空格内容
	 * @param str
	 * @param splitor
	 * @return 可能返回null
	 */
	public static String[] splitToTrimStrings(String str, String splitor) {
		if (str == null || str.isEmpty() || str.trim().isEmpty())
			return null;
		String[] ary = str.split(splitor);
		
		List<String> list = new ArrayList<String>();
		
		for (int i=0; i<ary.length; i++) {
			if (ary[i].trim().isEmpty()) {
				continue;
			}
			
			list.add(ary[i].trim());
		}
		
		return list.toArray(new String[list.size()]);
	}
	
	
	/**
	 * 判断字符串是否为null或者trim后为0长度字符串
	 * @param orignObj
	 * @return
	 */
	public static boolean isNullorEmptyStr(String orignObj) {
		if ((orignObj == null) || (orignObj.trim().equals(""))) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * <p>首字母变大写,判断字符串是否为null或者trim后为0长度字符串,返回""</p>
	 * @param str
	 * @return String
	 * @since   1.0.0
	 */
	public static String upperFirstLetter(String str){
		if (StringUtil.isNullorEmptyStr(str)) {
			return "";
		}
        return str.substring(0, 1).toUpperCase()+str.substring(1);
    }
	
	/**
	 * <p>首字母变小写,判断字符串是否为null或者trim后为0长度字符串,返回""</p>
	 * @param str
	 * @return String
	 * @since   1.0.0
	 */
	public static String lowerFirstLetter(String str){
		if (StringUtil.isNullorEmptyStr(str)) {
			return "";
		}
        return str.substring(0, 1).toLowerCase()+str.substring(1);
    }
	
	/**
	 * 如果字符串是null，那么给它付一个的值
	 * @param orignObj 需要检测的String对象
	 * @param newObj orignObj为null时，给orignObj付的值
	 * @return 如果orignObj==null返回newObj，否则返回orignObj
	 * @author wzy
	 */
	public static String clearNull(String orignObj,String newObj) {
    	if (orignObj ==  null) {
    		return newObj;
    	} else {
    		return orignObj;
    	}
    }


	/**
	 * 判断字符串中是否含有汉字，true:含有汉字，false：不含汉字
	 * @param str 待判断字符串
	 * @return true:含有汉字，false：不含汉字
	 * @author wzy
	 * @date 2022/10/6 10:08
	 */
	public static boolean isContailChinese(String str) {
		if (StringUtil.isNullorEmptyStr(str)) {
			return false;
		}
//		Java用的是Unicode 编码char 型变量的范围是0-65535 无符号的值，可以表示 65536个字符，基本上地球上的字符可被全部包括了
//		汉字基本集中在[19968,40869]之间,共有20901个汉字
//		unicode编码范围：
//		汉字：[0x4e00,0x9fa5]（或十进制[19968,40869]）
//		数字：[0x30,0x39]（或十进制[48, 57]）
//		小写字母：[0x61,0x7a]（或十进制[97, 122]）
//		大写字母：[0x41,0x5a]（或十进制[65, 90]）
		Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
		Matcher m = p.matcher(str);
		//发现匹配的字符
		if (m.find()) {
			return true;
		}
		return false;
	}

	/** 
	 * 替换最后匹配的字符串
	 * @param originStr 原字符串
	 * @param strToReplace 需要被替换的字符串
	 * @param replaceWithThis  替换成的字符串
 	 * @return java.lang.String
	 * @author wzy
	 * @date 2023/2/15 20:26
	 */
	public static String replaceLast(String originStr, String strToReplace, String replaceWithThis) {
		return originStr.replaceFirst("(?s)" + strToReplace + "(?!.*?" + strToReplace + ")", replaceWithThis);
	}

	/**
	 * 删除字符串中所有的标点符号，包含全角半角
	 * @param originStr 原始字符串
	 * @return 删除字符串中所有的标点符号的字符串
	 * @author wzy
	 * @date 2023/2/18 21:41
	 */
	public static String deleteAllPunctuation(String originStr) {
		if (StringUtil.isNullorEmptyStr(originStr)) {
			return originStr;
		}
		return originStr.replaceAll("[\\p{P}]","");
	}

	/** 
	 * 获得regex字符串在originStr字符串中N次出现的位置
	 * @param originStr 原字符串
	 * @param regex 规则字符串
	 * @param times 出现次数
	 * @return -1：未找到；-2：找到规则字符串，但未到达times次；其他返回N次出现的位置
	 * @author wzy
	 * @date 2023/4/17 20:57
	 */
	public static int getNTimePos(String originStr, String regex, int times){
		if (originStr == null || regex == null) {
			return  -1;
		}
		//获取regex"符号的位置
		Matcher findMatcher = Pattern.compile(regex).matcher(originStr);
		int ntime = 0;
		while(findMatcher.find()) {
			ntime++;
			//第times次出现的位置
			if(ntime == times){
				break;
			}
		}
		//originStr没找到regex
		if (ntime == 0) {
			return -1;
		} else if (ntime != times) {
			return -2;
		}else {
			return findMatcher.start();
		}
	}

	public static void main(String[] args) {
		String str = "/abpi/abtms/common/test";
		int pos = StringUtil.getNTimePos(str,"/ab",1);

//		for (int i = 0; i< 10;i++) {
//			int pos = (int) (Math.random() * 2 + 0.5);
//		}
	}


}
