/**
 * 功能描述: XML文件操作相关工具类
 * @author 魏振永
 * @version 1.0
 * @since 1.0   -  2022年9月28日
 */
package com.peak.common.util;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class XMLUtil {

	/**
	 * 获取 xml文件的Document对象
	 * @param is 需要解释文件的文件流
	 * @return xml文件的Document对象
	 * @author wzy
	 * @date 2022/9/28 15:10
	 */
	public static Document getDocument(InputStream is) throws Exception {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

//			factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
//			factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
		DocumentBuilder	builder = factory.newDocumentBuilder();
		Document doc = builder.parse(is);
		return builder.parse(is);
	}
	/**
	 * 获取 xml文件的Document对象
	 * @param file 需要解释文件的文件对象
	 * @return xml文件的Document对象
	 * @author wzy
	 * @date 2022/9/28 15:10
	 */
	public static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
//			factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
//			factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
		DocumentBuilder	builder = factory.newDocumentBuilder();
		return builder.parse(file);
	}

	/**
	 * 获得当前节点的属性的值
	 * @param node 节点对象
	 * @param attrName 属性名称
 	 * @return attrName的属性值
	 * @author wzy
	 * @date 2022/9/28 15:11
	 */
	public static String getAttribute(Node node, String attrName) {
		NamedNodeMap attrs = node.getAttributes();//获取节点的所有属性集合
		//循环遍历所有属性集合
		for (int i = 0; i < attrs.getLength(); i++) {
			Node attr = attrs.item(i);//记录每一次循环的当前属性
			//遍历的属性名称等于需要取值的属性名
			if (attr.getNodeName().equalsIgnoreCase(attrName))
				if (!attr.getNodeValue().equalsIgnoreCase("null"))
					return attr.getNodeValue();
		}
		return null;
	}

	/**
	 * 获得当前节点的值
	 * @param node 节点对象
	 * @return 节点对象的值
	 * @author wzy
	 * @date 2022/9/28 15:11
	 */
	public static String getText(Node node) {
		NodeList nl = node.getChildNodes();

		for (int i = 0; i < nl.getLength(); i++) {
			Node text = nl.item(i);
			if ((text.getNodeType() == Node.TEXT_NODE)
					|| (text.getNodeType() == Node.CDATA_SECTION_NODE)) {
				return text.getNodeValue().trim();
			}
		}
		return null;
	}
}
