package com.peak.common.util;


import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/** 工具类 */
public class ZipUtil {

	public static Object[] unzip(String unZipfileName, String destdir) {
		return unzip(unZipfileName,destdir,null);

	}

	/**
	 * 解压zip文件到指定目录，支持zip文件中带有中文
	 * @param unZipfileName 待解压文件全路径
	 * @param destdir  解压到哪个文件夹，需要以“/”结尾
	 * @param allowExts 此参数已经废弃，白名单通过系统配置文件读取
	 * @return oklist：zip中文件类型合法的文件名list，errlist：zip中文件类型不合法的文件名list
	 * @author wzy
	 * @date 2023/4/24 16:31
	 * @Deprecated 2024-12-13不建议使用，建议使用本类的unzip(String unZipfileName, String destdir)
	 */
	@Deprecated
	public static Object[] unzip(String unZipfileName, String destdir, String allowExts) {

		int             readedBytes;
		byte[]          buf = new byte[4096]; 
		FileOutputStream fileOut;
		File file;
		InputStream inputStream;
		ZipFile zipFile = null;
		List<String> oklist = new ArrayList<String>();
		List<String> errlist = new ArrayList<String>();
		
		try {
			//支持zip文件中存在中文
			zipFile = new ZipFile(unZipfileName, Charset.forName("GBK"));

			for (Enumeration entries = zipFile.entries(); entries.hasMoreElements();) {
				ZipEntry entry = (ZipEntry) entries.nextElement();
				file = new File(destdir + entry.getName());
				
				if (entry.isDirectory()) {
					if (!file.exists()) {
						if (file.mkdirs()) {
							oklist.add(file.getAbsolutePath());
						}
					}
				}  else {
//					if (allowExts != null) {
						String fileName = file.getName();
//						String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
//						if (!Arrays.<String>asList(allowExts.split(",")).contains(fileExt)) {
						if (!SecurityUtil.isZipAllowFileext(fileName)) {
							errlist.add(file.getAbsolutePath());
							continue; // 不在后缀清单内
						}
//					}
					
					// 如果指定文件的目录不存在,则创建之.
					File parent = file.getParentFile();
					if (!parent.exists()) {
						parent.mkdirs();
					}

					inputStream = zipFile.getInputStream(entry);

					fileOut = new FileOutputStream(file);
					while ((readedBytes = inputStream.read(buf)) > 0) {
						fileOut.write(buf, 0, readedBytes);
					}
					fileOut.close();

					inputStream.close();
					
					oklist.add(file.getAbsolutePath());
				}
			} // end of loop
		} 
		catch (IOException ioe) {
			ioe.printStackTrace();
		}
		finally {
			if (zipFile != null) {
				try {
					zipFile.close();
				} 
				catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		return new Object[]{oklist, errlist};
	}
	
	/**
	 * 将指定路径的文件打包成ZIP
	 * @param imgUrl  需要打包的路径集合
	 * @param zipFilePathExport 打包后zip所在的文件夹
	 * @param zipFileName 打包后zip文件名
	 * @return
	 */
	public static String toZip2(List<String> imgUrl,String zipFilePathExport,String zipFileName) {
		
	    ZipOutputStream zos = null ; 
	    BufferedOutputStream out;
	    try {
			out = new BufferedOutputStream(new FileOutputStream(new File(zipFilePathExport +"/"+ zipFileName)));
			zos = new ZipOutputStream(out);
			
			// 将所有文件打包进zip包
			for (String isfileUrl : imgUrl) {
				File isfile = new File(isfileUrl);
				isfileUrl = isfileUrl.replace("\\", "/");
				String fileName = isfileUrl.substring(isfileUrl.lastIndexOf("/")+1);
				
				if(isfile.exists()) {
			    	InputStream in = new BufferedInputStream(new FileInputStream(isfile));
			    	zos.putNextEntry(new ZipEntry(fileName));
			    	byte[] b2 = new byte[1024];
			    	int bytesRead2;
			    	while ((bytesRead2 = in.read(b2)) > 0) {
			    		zos.write(b2, 0, bytesRead2);
			    	}
			    	in.close();
			    	zos.closeEntry();
			    }
			}
	    }  catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				zos.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}			
	    // 返回zip的路径（传回页面进行导出）
		return zipFilePathExport + "/" + zipFileName;
		
	}

	public static void main(String[] args) {
		String zip = "F:\\tmp\\课程导入多层.zip";
		Object[] obj = ZipUtil.unzip(zip,"e:/tmp/",null);
		List<String> oklist = (ArrayList)obj[0];
	}
}
