package com.peak.demo;

import com.peak.common.util.ConvertUtil;

import com.peak.common.util.JsonUtil;
import com.peak.common.util.ListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;

/**
 * @author wzy
 * @date 2022/8/27 10:14
 */
@Slf4j
public class Demo {
    public static void main(String[] args) {
//        mapSetPropertiesDemo();
        TestsortByTree();
    }

    private static void TestsortByTree() {
        List<NodeTree> nodeTrees = new ArrayList<>();
        NodeTree nodeTree1 = new NodeTree(1011L,"no1011",101L);
        NodeTree nodeTree2 = new NodeTree(101L,"no101",10L);
        NodeTree nodeTree3 = new NodeTree(10L,"no10",0L);
        NodeTree nodeTree4 = new NodeTree(102L,"no102",10L);
        NodeTree nodeTree5 = new NodeTree(1012L,"no1012",101L);
        nodeTrees.add(nodeTree1);
        nodeTrees.add(nodeTree2);
        nodeTrees.add(nodeTree3);
        nodeTrees.add(nodeTree4);
        nodeTrees.add(nodeTree5);
        log.debug("nodeTrees======="+ JsonUtil.objectToJson(nodeTrees));
        nodeTrees = ListUtil.sortByTree(nodeTrees,NodeTree::getId,NodeTree::getParentId);
        log.debug("ListUtil nodeTrees======="+JsonUtil.objectToJson(nodeTrees));


    }

    /**
     *  ConvertUtil.setProperties(List<T> sourceList, Map<K,V> propertyMap,
     * 												Function<T,R> getFunc, BiConsumer<T,V> setFunc)
     *  使用示例
     * @author wzy
     * @date 2022/8/27 11:10
     */
    private static void mapSetPropertiesDemo(){
        Person p1 = new Person(100L,"zhangsan");
        Person p2 = new Person(101L,"lisi");
        Person p3 = new Person(102L);
        Person p4 = new Person(103L);
        Person p5 = new Person(104L);
        List<Person> personList = new ArrayList<>();
        personList.add(p1);
        personList.add(p2);
        personList.add(p3);
        personList.add(p4);
        personList.add(p5);
        Map<Long,String> map = new HashMap<>();
        map.put(102L,"wangwu");
        map.put(103L,"maliu");
        ConvertUtil.setProperties(personList,map,Person::getUserId,Person::setName);

    }
}
