package com.peak.framework.common;

import java.io.Serializable;
import com.peak.framework.common.util.ObjectUtils;

/**
 * 
 * 功能描述：数据库实体基础类
 * @author zhao
 * @version 2011-6-12 v1.0
 */
public  abstract class BaseEntity implements Serializable {

	private static final long serialVersionUID = -7200095849148417467L;

	protected static final String DATE_FORMAT = "yyyy-MM-dd";
	
	protected static final String TIME_FORMAT = "HH:mm:ss";
	
	protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
	
	protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
	
	/**
	 * 功能描述：是否显示多选框
	 */
	private boolean   showCheckBox=true;
	/**
	 * 是否被选中
	 */
	private boolean   checked=false;
	/**
	 * 功能描述：是否是创建的
	 * @return
	 */
	public abstract  boolean isNew();
	/**
	 * 功能描述：扩展的sql条件片断
	 * @return
	 */
	private  String  extSql;
	/**
	 * ext 树使用 
	 */
	private Boolean leaf=false;


	public Boolean getLeaf() {
		return leaf;
	}
	public void setLeaf(Boolean leaf) {
		this.leaf = leaf;
	}
	public String getExtSql() {
		return extSql;
	}
	public void setExtSql(String extSql) {
		this.extSql = extSql;
	}
	public boolean isShowCheckBox() {
		return showCheckBox;
	}
	public void setShowCheckBox(boolean showCheckBox) {
		this.showCheckBox = showCheckBox;
	}
	public boolean isChecked() {
		return checked;
	}
	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public boolean isNullOrEmpty(Object obj){
		return ObjectUtils.isNullOrEmptyString(obj);
	}
	public String getInputHidden(){
		return "hidden";
	}
    public  String toFirstUpper(String className){
	  if(className==null|| "".equals(className)) return "";
	   return className.substring(0,1).toUpperCase()+className.substring(1);
	}
    //模糊查询支持属性 
    public String getAsk() {
		return ask;
	}
	public void setAsk(String ask) {
		this.ask = ask;
	}
	public int getAskType() {
		return askType;
	}
	public void setAskType(int askType) {
		this.askType = askType;
	}
	public String getqShow() {
		return qShow;
	}
	public void setqShow(String qShow) {
		this.qShow = qShow;
	}
	public String ask;
    public int  askType=1;
    public String qShow;
	

    
}
