package com.peak.framework.common;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.dao.support.DaoSupport;

import com.peak.framework.common.dict.DictUtil;
import com.peak.framework.common.page.IPage;
import com.peak.framework.common.page.IQuery;
import com.peak.framework.common.page.PaginationUtil;
/**
 * 
 * 功能描述：基础功能dao
 * @author zhao
 * @version 2011-6-12 v1.0
 * @param <E> 实体类
 * @param <PK> 主键类型
 * @param <V>  请求实体类
 */
public abstract class BaseIbatis3Dao<E extends BaseEntity,PK,V extends IQuery<E>> extends DaoSupport implements IEntityDao<E,PK,V> {
    protected  final Log log = LogFactory.getLog(getClass());
    private  static int count=0;
    private Class<E> entityClass;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    public BaseIbatis3Dao(){
       count++;
   	   log.debug(count+":"+this.getClass().getName());
   	  
    }
	protected void checkDaoConfig() throws IllegalArgumentException {
		if(sqlSessionFactory==null){
			throw new IllegalArgumentException("sqlSessionFactory 没有加载 ");
		}
	}

	public SqlSessionFactory getSqlSessionFactory() {
		return sqlSessionFactory;
	}

	public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
		this.sqlSessionFactory = sqlSessionFactory;
		this.sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
	}

    public SqlSessionTemplate getSqlSessionTemplate() {
    	return sqlSessionTemplate;
    }
    /**
     * 功能描述：通过id加载实体
     */
	@SuppressWarnings("unchecked")
	public E getById(PK id) {
        E selectOne = (E) getSqlSessionTemplate().selectOne(getByIdStatement(), id);
        return selectOne;
    }
	/**
	 * 功能描述通过唯一编码加载实体
	 * @param id
	 * @return
	 */
	public E getByCode(Object code) {
		List<E> list= this.getSqlSessionTemplate().selectList(getByCodeStatement(), code);
		if(list==null||list.size()==0){
			return null;
		}else if(list.size()==1){
			return list.get(0);
		}
		throw new  RuntimeException(list.get(0).getClass().getName()+"发现多个实体 code:"+code);
    }
	public long count(V query){
		Long affectCount = (Long) getSqlSessionTemplate().selectOne(getCoutStatement(), query);
		return affectCount;
   }
    /**
     * 功能描述：通过id删除实体
     */
	public int deleteById(PK id) {
		int affectCount = getSqlSessionTemplate().delete(getDeleteStatement(), id);
		if(affectCount>0){
			this.modify(DELETE);
		}
		return affectCount;
	}
	public int deleteByIds(Collection<PK> ids){
			int affectCount = getSqlSessionTemplate().deleteAll(getDeleteStatement(), (Collection<Object>)ids);
			if(affectCount>0){
				this.modify(DELETE);
			}
			return affectCount;
	}
	
	/**
	 * 功能描述：添加实体
	 */
    public int insert(E entity) {
    	int affectCount = getSqlSessionTemplate().insert(getInsertStatement(), entity); 
    	if(affectCount>0){
			this.modify(INSERT);
		}
    	return affectCount;
    }
    public int insert(Collection<E> entitys) {
    	int affectCount = getSqlSessionTemplate().insertAll(getInsertStatement(), entitys); 
    	if(affectCount>0){
			this.modify(INSERT);
		}
    	return affectCount;
    }
    public int insertBatch(Collection<E> entitys) {
    	int affectCount = getSqlSessionTemplate().insertBatchAll(getInsertStatement(), entitys); 
    	if(affectCount>0){
			this.modify(INSERT);
		}
    	return affectCount;
    }
	public int update(E entity) {
		int affectCount = getSqlSessionTemplate().update(getUpdateStatement(), entity);
		if(affectCount>0){
			this.modify(UPDATE);
		}
		return affectCount;
	}
	public int updateSelective(E entity) {
		int affectCount = getSqlSessionTemplate().update(getUpdateSelective(), entity);
		if(affectCount>0){
			this.modify(UPDATE);
		}
		return affectCount;
	}
	
	public int saveOrUpdate(E entity) {
		if(entity.isNew()== true) {
			return insert(entity);
		}
		else {
			return update(entity);
		}
		 
	}
	public List<E> findAll(V query) {
		//return getSqlSessionTemplate().selectList(this.getFindAllStatement(), query);
		//zgd 
		return getSqlSessionTemplate().selectList(this.getFindAllStatement(), query,1,5000);
		
	}
	public List<E> findAll(V query,int startIndex,int limit) {
		if(startIndex<1) {startIndex=1;} if(limit<0) {limit=1;}
		return getSqlSessionTemplate().selectList(this.getFindAllStatement(), query,startIndex,limit);
		
	}
	public V findPage(V query) {
		return (V) pageQuery(this.getNamespace()+".findPage",query);
	}
	
	/**
	 * 功能描述：子类需要的覆盖的命名空间类，默认为实体类名称
	 */
    public String getNamespace() {
    	if(entityClass==null){
    		return "";
    	}
       return  entityClass.getSimpleName();
    }
    //---mapper文件语句id 
    public String getByIdStatement() {
        return getNamespace()+".getById";
    }
    public String getByCodeStatement() {
        return getNamespace()+".getByCode";
    }
    public String getCoutStatement() {
        return getNamespace()+".count";
    }
    public String getInsertStatement() {
        return getNamespace()+".insert";
    }

    public String getUpdateStatement() {
    	return getNamespace()+".update";
    }
    public String getUpdateSelective() {
    	return getNamespace()+".updateSelective";
    }
    public String getDeleteStatement() {
    	return getNamespace()+".delete";
    }
    public String getFindAllStatement() {
    	return getNamespace()+".findAll";
    }
    public String getCountStatementForPaging(String statementName) {
		return statementName +".count";
	}
    
	protected IQuery<E> pageQuery(String statementName, IQuery<E> query) {
		return pageQuery(getSqlSessionTemplate(),statementName,getCountStatementForPaging(statementName),query);
	}
	
	public   static <E> IQuery<E> pageQuery(SqlSessionTemplate sqlSessionTemplate,String statementName,String countStatementName, IQuery<E> query) {
	    IPage<E> page = query.getPage(); //分页设置
		Number totalCount = (Number) sqlSessionTemplate.selectOne(countStatementName,query);
		if(totalCount == null || totalCount.longValue() <= 0) {
			page.setTotalCount(0);
			return query;
		}
		page.setTotalCount(totalCount.intValue());
		PaginationUtil paginationUtil=new PaginationUtil(query.getPage());
		List<E> list = sqlSessionTemplate.selectList(statementName, query,paginationUtil.getThisPageFirstRowNumber(),page.getPageSize());
		page.setResult(list);
		return query;
	}
	
	public  static class SqlSessionTemplate {
		protected  static final Log LOGGER = LogFactory.getLog(SqlSessionTemplate.class);
		SqlSessionFactory sqlSessionFactory;
		public SqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
			this.sqlSessionFactory = sqlSessionFactory;
		}
        /**
         * 功能描述：核心查询类
         * @param action
         * @return
         */
		public  Object execute(SqlSessionCallback action)  {
		//public synchronized Object execute(SqlSessionCallback action)  {
			SqlSession session = null;
			try {
				 session = sqlSessionFactory.openSession();	
				 Object result = action.doInSession(session);
				return result;
			}catch(java.lang.Throwable ex){
				if(session != null){
				   session.rollback();
				}
				LOGGER.error(ex);
				throw new RuntimeException(ex);
			}finally {
				if(session != null){
				   session.close(); 
				}
			}
		}
		public  Object executeBatch(SqlSessionCallback action)  {
			SqlSession session = null;
			try {
				session = sqlSessionFactory.openSession(ExecutorType.BATCH,false);
				Object result = action.doInSession(session);
			    session.commit();//TODO这里可能不需要提交
				return result;
			}catch(java.lang.Throwable ex){
				if(session != null){
				  session.rollback();
				}
				LOGGER.error(ex);
				throw new RuntimeException(ex);
			}finally {
				if(session != null){
				  session.close();
				}
			}
		}
		public void debugSql(String sqlName){
			if(LOGGER.isDebugEnabled()){
				 LOGGER.debug("执行sql:"+sqlName);
			}
		}
		/**
		 * 
		 * @param statement
		 * @param parameter
		 * @return
		 */
		public Object selectOne(final String statement,final Object parameter) {
			debugSql(statement);
			return execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.selectOne(statement, parameter);
				}
			});
		}
		public List selectList(final String statement,final Object parameter,final int offset,final int limit) {
			debugSql(statement);
			return (List)execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.selectList(statement, parameter, new RowBounds(offset,limit));
				}
			});
		}
		/**
		 * 查询不限制
		 * @param statement
		 * @param parameter
		 * @return
		 */
		public List selectList(final String statement,final Object parameter) {
			debugSql(statement);
			return (List)execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.selectList(statement, parameter);
				}
			});
		}
		
		public int delete(final String statement,final Object parameter) {
			debugSql(statement);
			return (Integer)execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.delete(statement, parameter);
				}
			});
		}
		/**
		 * 功能描述：靠主键删除多个对象
		 * @param statement
		 * @param parameterList
		 * @return
		 */
		public int deleteAll(final String statement,final Collection<Object> parameterList) {
			debugSql(statement);
			return (Integer)execute(new SqlSessionCallback() {
				int count=0;
				public Object doInSession(SqlSession session) {
					for(Object parameter:parameterList){
					 count +=session.delete(statement, parameter);
					}
					return new Integer(count);
				}
			});
		}
		public int update(final String statement,final Object parameter) {
			debugSql(statement);
			return (Integer)execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.update(statement, parameter);
				}
			});
		}
		
		public int insert(final String statement,final Object parameter) {
			debugSql(statement);
			
			return (Integer)execute(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					return session.insert(statement, parameter);
				}
			});
		}
		public int insertAll(final String statement,final Collection parameterList) {
			debugSql(statement);
			return (Integer)execute(new SqlSessionCallback() {
				int count=0;
				public Object doInSession(SqlSession session) {
					for(Object parameter:parameterList){
					 count +=session.insert(statement, parameter);
					}
					return new Integer(count);
				}
			});
		}
		public int insertBatchAll(final String statement,final Collection parameterList) {
			debugSql(statement);
			return (Integer)executeBatch(new SqlSessionCallback() {
				public Object doInSession(SqlSession session) {
					for(Object parameter:parameterList){
					  session.insert(statement, parameter);
					}
					return new Integer(parameterList.size());
				}
			});
		}
		
		
	} 
	
	public static interface SqlSessionCallback {
		public Object doInSession(SqlSession session);
	}
	protected static String getInStringSql(Collection<String> idSet) {
		String ids="";
		String split="";
	    for(String childId:idSet){
	    	ids+=split+"'"+childId+"'";
	    	split=",";
	    }
		return ids;
	}
	public void modify(int opetion){
		
	}
	/**
	 *功能描述：清空相关字典缓存
	 */
	protected void clearDict(){
		DictUtil.clearDict(this.getClass());
	}
	public  void flush(){
		
	}
}
