package com.peak.framework.common;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;
import com.peak.framework.common.page.IQuery;

/**
 * @author zhaoguodong
 */
public abstract class BaseService <E,PK,V extends IQuery<E>> implements IEntityService<E,PK,V>{
	
	protected Log log = LogFactory.getLog(getClass());
	
	public E getById(PK id) {
		return getEntityDao().getById(id);
	}
	public List<E> findAll(V query) {
		return getEntityDao().findAll(query);
	}
	public List<E> findAll(V query,int startIndex,int limit){
		return getEntityDao().findAll(query,startIndex,limit);
	}
	public V findPage(V query) {
		return getEntityDao().findPage(query);
	}
	/** 根据id检查是否插入或是更新数据 */
	public int saveOrUpdate(E entity) {
		return getEntityDao().saveOrUpdate(entity);
	}
	
	public int insert(E entity) {
		return getEntityDao().insert(entity);
	}
	public int  deleteById(PK id) {
		return getEntityDao().deleteById(id);
	}
	
	public int update(E entity) {
	   return	getEntityDao().update(entity);
	}
	public int updateSelective(E entity) {
		   return	getEntityDao().updateSelective(entity);
	}
	public E getByCode(Object code) {
		return	getEntityDao().getByCode(code);
	}
	public long count(V query) {
		return	getEntityDao().count(query);
	}
	public int insert(Collection<E> entitys) {
		return getEntityDao().insert(entitys);
	}
	public int insertBatch(Collection<E> entitys) {
		return getEntityDao().insertBatch(entitys);
	}
	public int deleteByIds(Collection<PK> ids) {
		return getEntityDao().deleteByIds(ids);
	}
}
