package com.peak.framework.common;

import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import com.peak.framework.common.page.IQuery;
/**
 * 
 * 功能描述：核心实体dao接口
 * @author zhao
 * @version 2011-6-12 v1.0
 * @param <E> 实体类
 * @param <V> View Object
 * @param <PK> 主键类型
 */
public interface IEntityDao <E,PK,V extends IQuery<E>>{
	public  static int UPDATE=2;
	public  static int INSERT=1;
	public  static int DELETE=-1;
   /**
    * 功能描述：主键加载实体
    * @param id 主键
    * @return
    * @throws DataAccessException
    */
	public E getById(PK id) throws DataAccessException;
	/**
	 * 功能描述：通过唯一编码获取实体
	 * @param code
	 * @return
	 */
	public E getByCode(Object code) ;
	/**
	 * 功能描述：返回统计个数 
	 * @param query
	 * @return
	 */
	public long count(V query);
	/**
	 * 功能描述：主键删除实体
	 * @param id 主键
	 * @throws DataAccessException
	 */
	public int deleteById(PK id) throws DataAccessException;
	public int deleteByIds(Collection<PK> ids) throws DataAccessException;
	
    /**
     * 功能描述：添加实体
     * @param entity
     * @throws DataAccessException
     */
	public int insert(E entity) throws DataAccessException;
	public int insert(Collection<E> entitys) throws DataAccessException;
	public int insertBatch(Collection<E> entitys) throws DataAccessException;
	
	/**
	 * 功能描述：更新实体
	 * @param entity
	 * @throws DataAccessException
	 */
	public int update(E entity) throws DataAccessException;
	/**
	 * 功能描述：更新实体，不更新为空的属性
	 * @param entity
	 * @return
	 * @throws DataAccessException
	 */
	public int updateSelective(E entity) throws DataAccessException;

	/** 
	 * 功能描述:根据id检查是否插入或是更新数据 
     * @param entity
     * @throws DataAccessException
	 * @Deprecated 2024-11-2起不再推荐使用，需要使用单独insert或者update
    */
	@Deprecated
	public int saveOrUpdate(E entity) throws DataAccessException;
  
	/**
	 * 功能描述：加载符合条件的最多前5000条实体
	 * @param query 请求条件
	 * @return
	 * @throws DataAccessException
	 * @Deprecated 2024-11-2起不再推荐使用，推荐使用findList
	 */
	@Deprecated
	 public List<E> findAll(V query) throws DataAccessException;
	 /**
	  * 功能描述：加载符合条件的限制个实体
	  * @param query
	  * @param startIndex 开始的序号 从1开始
	  * @param limit  限制的行数
	  * @return
	  * @throws DataAccessException
	  * @Deprecated 2024-11-2起不再推荐使用，推荐使用findList
	  */
	 @Deprecated
	 public List<E> findAll(V query,int startIndex,int limit) throws DataAccessException;
	/**
	* 功能描述：加载符合条件的实体分页数据
	* @param query 请求条件
	* @return 
	* @throws DataAccessException
	*/
	public V findPage(V query) throws DataAccessException;
	/**
	 * 功能描述：获取ibatis 命名空间
	 */
	public String  getNamespace() ;
	/**
	 * 功能描述：数据改动时候回调 
	 * 功能描述： -1：删除 1：新增 2：修改
	 */
	public void modify(int opertion);
	public void flush() ; //提交
}
