package com.peak.framework.common;

import com.peak.framework.common.page.IQuery;
import org.springframework.dao.DataAccessException;

import java.util.Collection;
import java.util.List;
/**
 * 
 * 功能描述：核心实体dao接口
 * @author zhao
 * @version 2011-6-12 v1.0
 * @param <E> 实体类
 * @param <V> View Object
 * @param <PK> 主键类型
 */
public interface IEntityService <E,PK,V extends IQuery<E>>{
	/**
	 * 功能描述：获取当前核心实体dao
	 * @return
	 */
	public  IEntityDao<E,PK,V > getEntityDao();
   /**
    * 功能描述：主键加载实体
    * @param id 主键
    * @return
    * @throws DataAccessException
    */
	public E getById(PK id) ;
	/**
	 * 功能描述：通过唯一编码获取实体
	 * @param code
	 * @return
	 * @Deprecated 使用时需要确认好，mapper文件中存在Id为getByCode的sql
	 */
	@Deprecated
	public E getByCode(Object code) ;
	/**
	 * 功能描述：返回统计个数 
	 * @param query
	 * @return
	 */
	@Deprecated
	public long count(V query);
	/**
	 * 功能描述：主键删除实体
	 * @param id 主键
	 * @
	 */

	public int deleteById(PK id) ;
	@Deprecated
	public int deleteByIds(Collection<PK> id) ;
	
    /**
     * 功能描述：添加实体
     * @param entity
     * @
     */
	@Deprecated
	public int insert(E entity) ;
	@Deprecated
	public int insert(Collection<E> entityList);
	@Deprecated
	public int insertBatch(Collection<E> entitys) ;
	/**
	 * 功能描述：更新实体
	 * @param entity
	 * @
	 */
	@Deprecated
	public int update(E entity) ;
	/**
	 * 功能描述：更新实体 不更新为空的属性
	 * @param entity
	 * @return
	 */
	@Deprecated
	public int updateSelective(E entity) ;
	/** 
	 * 功能描述:根据id检查是否插入或是更新数据 
     * @param entity
     * @
    */
	@Deprecated
	public int saveOrUpdate(E entity) ;
  
	/**
	 * 功能描述：加载符合条件的最多100条实体
	 * @param query 请求条件
	 * @return
	 * @
	 */
	@Deprecated
	 public List<E> findAll(V query) ;
	 
	/**
	 * 功能描述：加载符合条件的实体分隔数据
	 * @param query
	 * @param startIndex 开始的索引 ，从1开始
	 * @param limit 返回的记录行
	 * @return
	 * @throws DataAccessException
	 */
	@Deprecated
	 public List<E> findAll(V query,int startIndex,int limit) throws DataAccessException;
	/**
	* 功能描述：加载符合条件的实体分页数据
	* @param query 请求条件
	* @return 
	* @
	*/
	public V findPage(V query) ;
	
}
