package com.peak.framework.common.cache;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCache implements ICache{
	public void add(String key, Object value) {
		add(key,value,-1);
	}
	public void add(String key, Object value, int expiration) {
		this.safeAdd(key, value, expiration);
	}
	public boolean safeAdd(String key, Object value) {
		return safeAdd( key,  value,  -1);
	}
	
	public long decr(String key, int by) {
	     return -1;
	}
	public long incr(String key, int by) {
		return -1;
	}
	
	public Map<String, Object> get(String[] keys) {
		Map<String,Object> map=new HashMap<String,Object>();
		for(String key:keys){
			map.put(key, this.get(key));
		}
		return map;
	}

	public void replace(String key, Object value) {
		replace(key,value,-1);
	}
	public void replace(String key, Object value,int expiration) {
		   safeReplace( key,  value,-1);
	}
	public boolean safeReplace(String key, Object value) {
		return safeReplace( key,  value,-1);
	}
	
	public void set(String key, Object value) {
		set( key,  value, -1);
	}
	public void set(String key, Object value, int expiration) {
		safeSet( key,  value,  expiration);
		
	}
	public boolean safeSet(String key, Object value) {
		return safeSet( key,  value,-1);
	}
	
	public void delete(String key) {
		  safeDelete(key);	
	}
}
