package com.peak.framework.common.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.peak.framework.common.cache.bean.LimitMap;
import com.peak.framework.common.cache.bean.TimeoutMap;
import net.sf.ehcache.CacheManager;
public class CacheFactory {
	 private static  CacheManager manager =null; 
	 private static Object SYN=new Object();
	 private static CacheManager getEhCacheManager(){
		 if(manager==null){
			 synchronized(SYN){
		       if(manager==null){
			     URL url = CacheFactory.class.getClassLoader().getResource("config/cache/ehcache.xml");  
			     manager=  CacheManager.create(url); 
		       }
		     }
		 }
	     return manager;
	 }
	 public static ICache createMapCache(int limit){
		 return new MapCache(new ConcurrentHashMap(limit));
	 }
	 public static ICache createLimitMapCache(int limit){
		 return new MapCache(new LimitMap(limit));
	 }
	 public static ICache createTimeoutMapCache(long time){
		 return new MapCache(new TimeoutMap(time));
	 }
	 private static Map<String,EhCache> EHCACHE_MAP=new HashMap<String,EhCache>();
	 public static ICache getEhCache(String cacheName){
		EhCache cacheHolder=EHCACHE_MAP.get(cacheName);
		if(cacheHolder==null){
			    synchronized(EHCACHE_MAP){
			    	cacheHolder=EHCACHE_MAP.get(cacheName);
			         if(cacheHolder==null){
			        	 cacheHolder=new EhCache();
			        	 EHCACHE_MAP.put(cacheName, cacheHolder);
			         }
			     }
		}
		if(manager==null)  getEhCacheManager();
		cacheHolder.setCache(manager.getCache(cacheName));
		return cacheHolder;
	 }
	 public void shutdownEhCache(){
		 manager.shutdown();
	 }
	 public static void removeEhCache(String cacheName){
			 EHCACHE_MAP.remove(cacheName);
			 manager.removeCache(cacheName);
	 }
	 public static long getSize(Object object) throws IOException{
		  ByteArrayOutputStream btys= new ByteArrayOutputStream();
		  ObjectOutputStream out=new ObjectOutputStream(btys);
		  out.writeObject(object);
		  out.close();
		  return   btys.size()-4;
	}
	 public static void main(String[] args){
		CacheManager manger=getEhCacheManager();
		for(String name: manger.getCacheNames()){
		}
	 }
}