package com.peak.framework.common.cache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
public class EhCache extends AbstractCache{
private Cache cache=null;
public void setCache(Cache cache) {
	this.cache = cache;
}
public  EhCache(){
}
public  EhCache(Cache cache){
	 this.cache=cache;
}
public void clear() {
	this.cache.removeAll();
}
public boolean containsKey(String key) {
	if(this.cache.get(key)!=null){
		return true;
	}
	return false;
}
public Object get(String key) {
	  Element element = this.cache.get(key);
	  if(element!=null) 
		  return element.getValue();
	  return null;
}
public boolean safeAdd(String key, Object value, int expiration) {
	   Element element = new Element(key, value);   
	   this.cache.put(element);
	   return true;
}
public boolean safeDelete(String key) {
	 return this.cache.remove(key);
}
public boolean safeReplace(String key, Object value, int expiration) {
	return  safeAdd( key,  value,  expiration);
}
public boolean safeSet(String key, Object value, int expiration) {
	return  safeAdd( key,  value,  expiration);
}
public void stop() {

}
public CacheType type() {
	return CacheType.EhCache;
}

}
