package com.peak.framework.common.cache;

import java.util.Map;

/**
 * 功能描述：缓存集合接口
 * @author zhao
 * add 缓存中没有存在的key
 * set 不关心缓存中有没有存在key
 * replace 缓存中必须存在key
 * 
 * 
 */
public interface ICache {
	public static enum CacheType {
		MapCache,TimeoutMap,OsCache,EhCache,LimitMap, MenCahce
	  }
	/**
	 * 功能描述：添加key ，如果存在不添加
	 * @param key
	 * @param value
	 */
    public void add(String key, Object value);
    /**
     * 功能描述：添加或者替换key
     * @param key
     * @param value
     */
    public void set(String key, Object value);
    /**
     * 功能描述：替换key
     * @param key
     * @param value
     */
    public void replace(String key, Object value);
	
	//这个实现可能不被支持
    public void add(String key, Object value, int expiration);
    public void set(String key, Object value, int expiration);
    public void replace(String key, Object value, int expiration);
    
    public boolean safeAdd(String key, Object value);
    public boolean safeSet(String key, Object value);
    public boolean safeReplace(String key, Object value);
    //-----------------核心方法-----------------------------------------
    public boolean safeAdd(String key, Object value, int expiration);
    public boolean safeSet(String key, Object value, int expiration);
    public boolean safeReplace(String key, Object value, int expiration);
    /**
     * 功能描述：获取对象
     * @param key
     * @return
     */
    public boolean containsKey(String key);
    public Object get(String key);
    public Map<String, Object> get(String[] keys);

    /**
     * 功能描述：删除key
     * @param key
     */
    public void delete(String key);
    public boolean safeDelete(String key);
    
    /**
     * 功能描述：使key对象 增加 by
     * @param key
     * @param by 增量
     * @return
     */
    public long incr(String key, int by);
    /**
     * 功能描述：使key对象 减少 by
     * @param key
     * @param by
     * @return
     */
    public long decr(String key, int by);
    /**
     * 功能描述：清空缓存
     */
    public void clear();
    /**
     * 功能描述：停用缓存
     */
    public void stop();
    
    public CacheType type();
}
