package com.peak.framework.common.cache;

import java.util.Map;

import com.peak.framework.common.cache.bean.LimitMap;
import com.peak.framework.common.cache.bean.TimeoutMap;

public  class MapCache extends AbstractCache {
	protected  Map cacahe_map;
	private  Object SYN=new Object();
	public   MapCache (Map map)  {
		cacahe_map=map;
	}
	public void clear() {
		 synchronized(SYN){
		    this.cacahe_map.clear();
		 }
	}
	public Object get(String key) {
		return this.cacahe_map.get(key);
	}
	public boolean safeAdd(String key, Object value, int expiration) {
		 if( cacahe_map.containsKey(key)){
			 throw new RuntimeException("系统缓存中已存在key="+key +"对象");
		 }
		 synchronized(SYN){
			 if( cacahe_map.containsKey(key)){
				 throw new RuntimeException("系统缓存中已存在key="+key +"对象");
			 }
			 cacahe_map.put(key, value);
		 }
		 return true;
	}
	public boolean safeDelete(String key) {
		    if( !cacahe_map.containsKey(key)){
				return false ;
			 }
		     synchronized(SYN){
				 if( cacahe_map.containsKey(key)){
					 cacahe_map.remove(key);
				 }
			 }
	     	return true;
	}
	public boolean safeReplace(String key, Object value, int expiration) {
		  return this.safeSet(key, value,expiration);
	}
	public boolean safeSet(String key, Object value, int expiration) {
		 synchronized(SYN){
			 cacahe_map.put(key, value);
		 }
		 return true;
	}
	public void stop() {
		this.clear();
		this.cacahe_map=null;
	}
	public boolean containsKey(String key) {
		return this.cacahe_map.containsKey(key);
	}
	public CacheType type() {
		if(this.cacahe_map instanceof TimeoutMap){
			return CacheType.TimeoutMap;
		}
		if(this.cacahe_map instanceof LimitMap){
			return CacheType.LimitMap;
		}
		return CacheType.MapCache;
	}

}
