package com.peak.framework.common.cache;
import java.util.HashMap;
import java.util.Map;

import com.peak.framework.common.cache.ICache.CacheType;

//import com.peak.memcached.client.CachedClient;
//import com.peak.memcached.server.CachedServerWin32;


/**
 * 功能描述：系统缓存
 * @author zhaoguodong
 *
 */
public class SystemCache {
  
  private  static Map<String,ICache>  CACHE_MAP=new HashMap<String,ICache>();
  /**
   * 功能描述：创建一个特定名称的Map缓存
   * @param cacheName
   * @param limit
   */
  public  static void create(String cacheName,int limit){ 
	  create(cacheName,CacheType.MapCache,limit);
  }
  public synchronized static void create(String cacheName,CacheType cacheType,long limit){
	     ICache  cache=null;
		 switch(cacheType){
	   	   case LimitMap:
	   		    cache=CacheFactory.createLimitMapCache((int)limit);
	 		    break;
	   	   case TimeoutMap:
	   		    cache=CacheFactory.createTimeoutMapCache(limit);
	 		    break;
	  
	   	   case EhCache:  
	   		     cache =CacheFactory.getEhCache(cacheName);
	 		     break;
	 	   case OsCache:
	 		     //TODO
	       case MapCache:
	   	   default: 
	   		    cache =CacheFactory.createMapCache((int)limit);
		 }
	     CACHE_MAP.put(cacheName.toUpperCase(), cache);
  }
  public static Object get(String cacheName,String key){
	   ICache  cache=CACHE_MAP.get(cacheName.toUpperCase());
	    switch(cache.type()){
	  	    case EhCache:  
	  		     cache =CacheFactory.getEhCache(cacheName);
		 	     break;
	  	    default: 
	   }
	   return cache.get(key);
  }
  public static void  set(String cacheName,String key,Object value){
	  ICache  cache=CACHE_MAP.get(cacheName.toUpperCase());
	    switch(cache.type()){
	  	    case EhCache:  
	  		     cache =CacheFactory.getEhCache(cacheName);
		 	     break;
	  	    default: 
	   }
	   cache.set(key, value);
  }
  public static void  delete(String cacheName,String key){
	   ICache  cache=CACHE_MAP.get(cacheName.toUpperCase());
	    switch(cache.type()){
	  	    case EhCache:  
	  		     cache =CacheFactory.getEhCache(cacheName);
		 	     break;
	  	    default: 
	   }
	   cache.delete(key);
 }
  public static void  clear(String cacheName){
	   ICache  cache=CACHE_MAP.get(cacheName.toUpperCase());
	    switch(cache.type()){
	  	    case EhCache:  
	  		     cache =CacheFactory.getEhCache(cacheName);
		 	     break;
	  	    default: 
	   }
	   cache.clear();
 }
  public static void  clear(){
	  for(String  cacheKey:CACHE_MAP.keySet()){
		    ICache  cache=CACHE_MAP.get(cacheKey);
		    switch(cache.type()){
		  	    case EhCache:  
		  		     cache =CacheFactory.getEhCache(cacheKey);
			 	     break;
		  	    default: 
		   }
		   cache.clear();
	  }
}
  public static void set(String cacheName,Map<String,Object> value){
	   ICache  cache=CACHE_MAP.get(cacheName.toUpperCase());
	   switch(cache.type()){
	  	    case EhCache:  
	  		     cache =CacheFactory.getEhCache(cacheName);
		 	     break;
	  	    default: 
	   }
	   for(String key:value.keySet()){//这里可以优化
	       cache.set(key, value.get(key));
	   }
  }

}
