package com.peak.framework.common.cache.bean;

import java.io.Serializable;  
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
/**
 * 缓存类 最早添加的
   * 运行一段时间后才能使最近最少使用的被删除
 */
public class LimitMap<K, V> extends LinkedHashMap<K, V> implements Serializable {
	public static final int DEFAULT_CAPASITY = 20;
	private  int CACHE_CAPASITY = DEFAULT_CAPASITY;
	public LimitMap() {
		super(DEFAULT_CAPASITY);
		CACHE_CAPASITY = DEFAULT_CAPASITY;
	}
	public LimitMap(int size) {
		super(size);
		CACHE_CAPASITY = size;
	}
	/*
	 * 是否删除最早未使用缓存对象
	 * @see java.util.LinkedHashMap#removeEldestEntry(java.util.Map.Entry)
	 */
	@Override
	protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
		return this.size() > CACHE_CAPASITY;
	}
}