package com.peak.framework.common.date;

import java.util.Calendar;
import java.util.Date;
/**
 * 功能描述：高效获取当前时间
 * 效率提高了20倍
 * @author  赵国栋
 * @version 2010-9-22 1.0v
 * 返回三种类型的日期字符串 ：   1 yyyy-MM-dd HH:mm:ss,yyyy-MM-dd, HH:mm:ss
 *                    2 yyyyMMddHHmmss ,yyyyMMdd,HHmmss
 */
public class CurrentDate {
	///中国时区
    public static final long  TIMEZONE=28800000;
    //一天的秒数
	private  final static long DAY=86400000;
	//一小时的秒数 
	private  final static long HS=3600;
	private  static String YYYY_MM_DD="";
	private  static String YYYYMMDD="";
	//下一天 零点
    private   static  long  NEXT_DAY_MS=0;
    
	public final static int yyyy_MM_dd_HH_mm_ss = 1;
    public final static int yyyyMMddHHmmss = 2;
	public final static int yyyy_MM_dd = 3;
	public final static int yyyyMMdd = 4;
	public final static int HH_mm_ss =5;
	public final static int HHmmss = 6;


	private static synchronized void  setYmd(){
		if(NEXT_DAY_MS>System.currentTimeMillis())  return ;
			long  time=System.currentTimeMillis()+TIMEZONE;
			long hms=time%DAY;
			NEXT_DAY_MS=time-hms-TIMEZONE+DAY;//下一天的时间		
			YYYY_MM_DD= getYYYY_MM_DD(new Date(),"-");
			YYYYMMDD=YYYY_MM_DD.replaceAll("-", "");
	}
	private static String getYYYY_MM_DD(Date date,String sp){
		StringBuffer returnStr=new StringBuffer(10);
		Calendar calendar=Calendar.getInstance();
		calendar.setTime(date);
	    int year=calendar.get(Calendar.YEAR);
	    returnStr.append(year);
	    returnStr.append(sp);
	    int m=calendar.get(Calendar.MONTH)+1;
	    if(m<10) returnStr.append("0");returnStr.append(m);
	    returnStr.append(sp);
	    int d=calendar.get(Calendar.DAY_OF_MONTH);
	    if(d<10) returnStr.append("0");returnStr.append(d);
		return returnStr.toString();
	}
	private  static String getHH_MM_SS(long dateTime,String sp){
		StringBuffer returnStr=new StringBuffer(14);
		long  time=dateTime+TIMEZONE;
		long hms=time%DAY/1000;
		long hour=hms/HS;
		if(hour<10) returnStr.append("0"); returnStr.append(hour);
		long mm=(hms%HS)/60; returnStr.append(sp);
		if(mm<10) returnStr.append("0"); returnStr.append(mm);
		long ss=(hms%HS)%60; returnStr.append(sp);
		if(ss<10) returnStr.append("0"); returnStr.append(ss);
		return returnStr.toString();
	}
	/**
	 * @return  yyyy-MM-dd
	 */
	private static String getDate(){
		 if(NEXT_DAY_MS<=System.currentTimeMillis()){
			setYmd();
	     }
		 return YYYY_MM_DD;
	}

	private static String getFlatDate(){
		if(NEXT_DAY_MS<=System.currentTimeMillis()){
			setYmd();//TODO 未同步 
		}
		return YYYYMMDD;
	}

	/**
	 * 
	 * @param date
	 * @return yyyy-MM-dd
	 */
	public static String get(){
		return getDate()+" "+ getHH_MM_SS(System.currentTimeMillis(),":");
	}
	public static String get(int format){
	   switch(format){
	    case  yyyyMMddHHmmss:  
	    	return getFlatDate()+ getHH_MM_SS(System.currentTimeMillis(),"");
	    case  yyyy_MM_dd:  
	    	return getDate();
	    case  yyyyMMdd:  
	    	return getFlatDate();
	    case  HH_mm_ss:  
	    	return getHH_MM_SS(System.currentTimeMillis(),":");
	    case  HHmmss:   
	    	return getHH_MM_SS(System.currentTimeMillis(),"");
	    case yyyy_MM_dd_HH_mm_ss:
	    default:
	         return getDate()+" "+ getHH_MM_SS(System.currentTimeMillis(),":"); 
	   }
	}
	public static String get(Date date,int format ){
		 long time=date.getTime();
		 switch(format){
		    case  yyyyMMddHHmmss:  
		    	return getYYYY_MM_DD(date,"")+ getHH_MM_SS(time,"");
		    case  yyyy_MM_dd:  
		    	return getYYYY_MM_DD(date,"-");
		    case  yyyyMMdd:  
		    	return getYYYY_MM_DD(date,"");
		    case  HH_mm_ss:  
		    	return getHH_MM_SS(time,":");
		    case  HHmmss:   
		    	return getHH_MM_SS(time,"");
		    case yyyy_MM_dd_HH_mm_ss:
		    default:
		        return getYYYY_MM_DD(date,"-")+" "+ getHH_MM_SS(time,":"); 
		   }
	}
	public static void main(String[] args){

	   
	}
	/**
	 * @deprecated get()
	 * @return
	 */
	public static String getYYYYMMDD(){
		return getFlatDate();
	}
	/**
	 * @deprecated get()
	 * @return
	 */
	public static String getTime(){
		return getFlatDate()+ getHH_MM_SS(System.currentTimeMillis(),"");
	}
}
