package com.peak.framework.common.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
/**
 * 功能描述：日期转换和从字符串中提取日期
 * @author zhaoguodong
 *
 */
@SuppressWarnings("serial")
public class DateUtil {
	public final static String yyyyMMddHHmmss = "yyyyMMddHHmmss";
	public final static String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
	public final static String yyyyMMdd = "yyyyMMdd";
	public final static String yyyy_MM_dd = "yyyy-MM-dd";
	public final static String HHmmss = "HHmmss";
	public final static String HH_mm_ss = "HH:mm:ss";
	public static final String yyyy年MM月dd日="yyyy年MM月dd日";
	public static final String yyyy年MM月dd日HH时="yyyy年MM月dd日HH时";
    public static final String yyyy年MM月dd日HH时m分="yyyy年MM月dd日HH时m分";   
    public static final String yyyy年MM月dd日HH时mm分ss秒="yyyy年MM月dd日HH时mm分ss秒";
    
	private static   Map<String,String> NUM_MAP=new HashMap<String,String>(){
		{          put("零","0");
				   put("一","1");
				   put("二","2");
				   put("三","3");
				   put("四","4");
				   put("五","5");
				   put("六","6");
				   put("七","7");  
				   put("八","8");
				   put("九","9");
				   put("十","");
				   put("年","-");
				   put("月","-");
		}
	};
	private static  Map<String,String> MONTH_MAP=new HashMap<String,String>(){

		{  put("JAN","01");
		  put("FEB","02");
		  put("MAR","03");
		  put("APR","04");
		  put("MAY","05");
		  put("JUN","06");
		  put("JUL","07");  
		  put("AUG","08");
		  put("SEP","09");
		  put("OCT","10");
		  put("NOV","11");
		  put("DEC","12");
		}
	};
	/**
	 * 功能描述：解析日期字符串
	 * @param dateString 日期字符串
	 * @param dateFormat 日期字符串样式 DateUtil中定义了一些常用的日期字符串样式
	 * @return 解析后的日期
	 */
	public static Date parse(String dateString,String dateFormat) {
		return parse(dateString, dateFormat,Date.class);
	}
	/**
	 * 功能描述：按照 yyyy-MM-dd hh:mm:ss 解析日期字符串
	 * @param dateString 日期字符串
	 * @return 解析后的日期
	 */
	public static Date parse(String dateString) {
		return  parse(dateString, yyyy_MM_dd_HH_mm_ss,Date.class);
	}
    /**
     * 功能描述：获取yyyy-MM-dd 格式的日期字符串
     * @param date 
     * @return
     */
	public static String getDate(Date date){
		return CurrentDate.get(date,CurrentDate.yyyy_MM_dd);
	}
	 /**
     * 功能描述：获取yyyy-MM-dd HH:mm:ss格式的日期字符串
     * @param date 
     * @return
     */
	public static String getTime(Date date){
		return CurrentDate.get(date,CurrentDate.yyyy_MM_dd_HH_mm_ss);
	}
	/* 功能描述：获取 HH:mm:ss格式的时间字符串
    * @param date 
    * @return
    */
	public static String getHHMMSS(Date date){
		return CurrentDate.get(date,CurrentDate.HH_mm_ss);
	}
	/* 功能描述：获取当前时间 yyyy-MM-dd 格式的日期字符串
	    * @param date 
	    * @return
	 */
	public static String getDate(){
		return  CurrentDate.get(CurrentDate.yyyy_MM_dd);
	}
	/* 功能描述：获取当前时间 yyyy-MM-dd HH:mm:ss格式的时间戳字符串
	    * @return
	 */
	public static String getTime(){
		return CurrentDate.get(CurrentDate.yyyy_MM_dd_HH_mm_ss);
	}
	/* 功能描述：获取当前时间 HH:mm:ss格式的时间字符串
	    * @return
	 */
	public static String getHHMMSS(){
		return  CurrentDate.get(CurrentDate.HH_mm_ss);
	}
	/* 功能描述：获取指定格式日期字符串
	    * @param date  日期
	    * @param dateFormat 日期格式
	    * @return
	 */
	public static String format(Date date,String dateFormat) {
		 if(date == null) return null;
		 return new SimpleDateFormat(dateFormat).format(date);
	}
	
	@SuppressWarnings("unchecked")
	public static <T extends Date> T parse(String dateString,String dateFormat,Class<T> targetResultType) {
		if(StringUtils.isEmpty(dateString))
			return null;
		DateFormat df = new SimpleDateFormat(dateFormat);
		try {
			long time = df.parse(dateString).getTime();
			Date t = targetResultType.getConstructor(long.class).newInstance(time);
			return (T)t;
		} catch (ParseException e) {
			String errorInfo = "cannot use dateformat:"+dateFormat+" parse datestring:"+dateString;
			throw new IllegalArgumentException(errorInfo,e);
		} catch (Exception e) {
			throw new IllegalArgumentException("error targetResultType:"+targetResultType.getName(),e);
		}
	}

	public static  String  pickUp(String content){
	
		Pattern p=Pattern.compile("(\\d{4})\\s*[-/年\\.]\\s*(\\d{1,2})\\s*[-/月\\.]\\s*(\\d{1,2})");
	
		Matcher mat = p.matcher(content);
		if(mat.find()){
			return mat.group(1)+"-"+twoSeat(mat.group(2))+"-"+twoSeat(mat.group(3));
		}
        Pattern p00=Pattern.compile("(\\d{4})(\\d{1,2})(\\d{1,2})");
		
		Matcher mat00 = p00.matcher(content);
		if(mat00.find()){
			return mat00.group(1)+"-"+twoSeat(mat00.group(2))+"-"+twoSeat(mat00.group(3));
		}
		Pattern p0=Pattern.compile("(\\d{1,2})\\s*[-/月\\.]\\s*(\\d{1,2})\\s*[-/日\\.]\\s*(\\d{4})");
	
		Matcher mat0 = p0.matcher(content);
		if(mat0.find()){
			return mat0.group(3)+"-"+twoSeat(mat0.group(1))+"-"+twoSeat(mat0.group(2));
		}
		Pattern p2=Pattern.compile("((?:一|二|三|四|五|六|七|八|九|零){4})\\s*年\\s*((?:一|二|三|四|五|六|七|八|九|零|十){1,2})\\s*月\\s*((?:一|二|三|四|五|六|七|八|九|零|十){1,3})");
		Matcher mat2 = p2.matcher(content);
		if(mat2.find()){
			return cnToNum(mat2.group(1))+"-"+twoSeat(cnToNum(mat2.group(2)))+"-"+twoSeat(cnToNum(mat2.group(3)));
		}
		Pattern p3=Pattern.compile("([Jj]anuary|Jan\\.|February|Feb\\.|March|Mar\\.|April|May|June|Jun|July|August|September|October|November|Nov\\.|December|Dec\\.)\\s*(\\d{1,2})\\s*(\\d{4})");
		Matcher mat3 = p3.matcher(content);
		if(mat3.find()){
			return mat3.group(3)+"-"+twoSeat(monthToNum(mat3.group(1)))+"-"+twoSeat(mat3.group(2));
		}
		return null;
	}
	public static String twoSeat(String str){
		if(str==null) return str;
		if(str.length()==1){
			str="0"+str;
		}
		return str;
	}
	public static String cnToNum(String cn){
		if(cn==null) return cn;
		if(cn.indexOf("十")!=-1){
			String num="(一|二|三|四|五|六|七|八|九|零){1}";
			cn=cn.replaceAll(num+"十"+num, "$1$2");
			cn=cn.replaceAll("(十)"+num, "一$2");
			cn=cn.replaceAll("(一|二|三){1}十", "$1零");
			cn=cn.replaceAll("十", "一零");
		}
		StringBuffer buffer=new StringBuffer();
		for(int i=0;i<cn.length();i++){
			String key=cn.charAt(i)+"";
			String temp=NUM_MAP.get(key);
			if(temp==null) continue;
			buffer.append(temp);
		}
		return buffer.toString();
	}
	public   static String monthToNum(String monthEnglish){
		 if(monthEnglish==null||monthEnglish.length()<3) return monthEnglish;
		 String key=monthEnglish.substring(0,3);
		 return MONTH_MAP.get(key.toUpperCase());
	}
    public static void main(String[] args){


    }
}
