package com.peak.framework.common.dict;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
/**
 * 功能描述：国际化扩展版本，目前仅支持两种语言 中文 英文
 * _Language_Country
 * @author zhao
 * @version 2012-2-27 v1.0
 */
public class I18N {
   public  static ThreadLocal<Locale> LOCALETHREADLOCAL=new ThreadLocal<Locale>();
   private Locale locale;
   private ResourceBundle myResource; //这个类需要缓存起来
   private String bundleId;
   private ResourceBundle loadBundle(String bundleId){
	   ResourceBundle  resourceBundle=null;
	   try{
		   resourceBundle=ResourceBundle.getBundle(bundleId, this.locale);
        }catch(Exception e){
//            System.out.println("不能发现 :config/i18n/base_"+this.locale.getLanguage());
		   e.printStackTrace();
        }
	    return resourceBundle;
   }
   private ResourceBundle BASE(){
	   return loadBundle("config/i18n/base");
   }
   private ResourceBundle ENTITIES(){
	   return loadBundle("config/i18n/entities");
   }
   /**
    * 这个方法只在调用用第一次的时候有用
    * @param properties
    */
   public void load(String bundleId){  
	   if(bundleId!=null && !"".equals(bundleId) && this.myResource==null ){
		    try{
		    	 this.myResource=ResourceBundle.getBundle(bundleId, this.locale, Thread.currentThread().getContextClassLoader());
	        }catch(Exception e){
//	        	 System.out.println("不能发现 :config/i18n/base_"+this.locale.getLanguage());
				e.printStackTrace();
	        }
	   }
   }
   
   public I18N (Locale locale ,String id){
	    this.locale=locale;
	    LOCALETHREADLOCAL.set(locale);
   }
 
   public I18N (Locale locale,String id,String bundleId){
	    this.locale=locale;
	    LOCALETHREADLOCAL.set(locale);
	    if(bundleId!=null && !"".equals(bundleId)){
		  this.bundleId=bundleId;
		  load(this.bundleId);
	   }
   }
 
   /*
    * 功能描述i18n跳转
    */
   public  String i18n(String name){ 
	   //if(DEFAULT_LOCALE.getLanguage().equals(locale.getLanguage())){
	   if(locale.getLanguage().indexOf("zh")>-1){
		   return name;
	   }
	   String returnValue=null; 
	   if(myResource!=null ){
		   returnValue=getValue(name,myResource);
		   if(returnValue!=null) return returnValue;
	   }
	   
	   returnValue=getValue(name,this.ENTITIES());
	   if(returnValue!=null) return returnValue;
	   
	   returnValue=getValue(name,this.BASE());
	   
	   if(returnValue!=null) return returnValue;
	   
  	   return name ;
   }
   public String base(String name){
	   //if(DEFAULT_LOCALE.getLanguage().equals(locale.getLanguage())){
	   if(locale.getLanguage().indexOf("zh")>-1){
		   return name;
	   }
	   String returnValue=getValue(name,BASE());
	   if(returnValue!=null) return  returnValue;
	   return name;  
   }
   public String entity(String name){
	   //if(DEFAULT_LOCALE.getLanguage().equals(locale.getLanguage())){
	   if(locale.getLanguage().indexOf("zh")>-1){
		   return name;
	   }
	   String returnValue=getValue(name,ENTITIES());
	   
	   if(returnValue!=null) return  returnValue;
	   return name; 
	  
   }
   private String getValue(String name,ResourceBundle resource){
	   String returnValue=null;
	   if(resource==null){return null;}
	   try{
		   returnValue=resource.getString(name); 
	   }catch(MissingResourceException ex){
		  if(this.BASE()==resource){
//			  System.out.println("config/i18n/base_"+this.locale.getLanguage()+".properties"+" key: "+name +"不存在");
		  }else if(this.ENTITIES()==resource){
//			  System.out.println("config/i18n/entities_"+this.locale.getLanguage()+".properties"+" key: "+name +"不存在");
		  }else if(this.myResource==resource){
//			  System.out.println(this.bundleId+"_"+this.locale.getLanguage()+".properties"+" key: "+name +"不存在");
		  }
	   }
	   return returnValue; 
	  
   }
   public  String i18n(String name ,String... param1){
	    String value=i18n(name);
       // 格式化参数,返回格式后的字符串 
        String result = MessageFormat.format(value, param1);
  	    return result;
   }
   public static void main(String[] args){
	   Locale locale=new Locale("zh","","");
	  //Locale locale=new Locale("zh","","");
	   I18N i18n=new I18N(locale,"id");
	   i18n.load("config/i18n/app/test");
//	   System.out.println(i18n.i18n("保存"));
//	   System.out.println(i18n.i18n("创建人"));
//	   System.out.println(DictUtil.getDictName("REDFIRE.BOOL","1"));

   }
}
