package com.peak.framework.common.dict;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 功能描述：字典服务类
 * @author zhao
 * @version 2011-9-14 v1
 * @version 2014-07-24
 */
@Service
public interface IDictService {
	    public static String DICT_PRE="DB_";
	    public static String DICTITEM_PRE="DBP_";
		/**
		 * 功能描述：加载字典
		 * @param dictCode
		 * @deprecated 
		 * @see loadDictList(String dictCode);
		 */
		 public List<Map> loadDict(String dictCode);
		 /**
		  * 功能描述：加载字典
		  * @param dictCode
		  * @param params
		  * @return
		  * @see loadDictList(String dictCode);
		  */
		 public List<Map> loadDictList(String dictCode);
		 public List<Map> loadDictList(String dictCode,Map params);
		/**
		 * 功能描述：加载单个翻译字典
		 * @param dictCode  dictCode必须以DBP_开始
		 * @param params   
		 * @return
		 */
	    public Map loadDict(String dictCode,String key) ;
		public Map loadDict(String dictCode,Map params) ;
	
		/**
		 * 功能描述：唯一性验证
		 * @param dictCode
		 * @param params
		 * @return
		 */
		public boolean unique(String dictCode,Map params);
		
		/**
		 * 功能描述：加载特定表的 BLOB字段 
		 * @param dictCode
		 * @param id
		 * @return
		 *   <result property="FILE_BLOB" column="FILE_BLOB" jdbcType="BLOB" javaType="[B" />
	     *   <result property="FILE_TYPE" column="FILE_TYPE"/>
		 */
		public Map  getFile(String dictCode,String id);
	}