package com.peak.framework.common.dict;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

import com.peak.framework.common.dict.DictUtil.Item;
import com.peak.framework.common.util.PropertiesHelper;

public class PropertiesDict {
	 /**
     * 功能描述：加载静态字典
     */
    public static   Map<String,Object> reloadProperties(String itemKey){
    	 try {
            Properties dictConfig =new Properties();
		    PropertiesHelper.loadAllPropertiesFromClassLoader(dictConfig,"config/dict/dict.properties");
		    Map<String,Object> dictMap=getDictMap(dictConfig,itemKey,"");
		    //英文版本
		    dictConfig.clear();
		    PropertiesHelper.loadAllPropertiesFromClassLoader(dictConfig,"config/dict/dict_en.properties");
		    Map<String,Object> dictMap2=getDictMap(dictConfig,itemKey,"EN_");
		    
		    dictMap.putAll(dictMap2);
		    
		    return dictMap;
	       } catch (IOException e) {
			  e.printStackTrace();
		   }
	       return Collections.EMPTY_MAP;
    }
	 /**
	  *功能描述：解析配置文件字典（静态字典)
	  * 解析配置文件格式为：
	  *         Map<ZdrAttributes.valueType:
	  *                Map<STRING:字符串;DATE:日期;NUMBER:数字;IMAGE:照片>
	  *             ZdrAttributes.valueType#ITEM_LIST:
	  *                List<
	  *                    Item(STRING,字符串),I
	  *                    Item(DATE,日期),
	  *                    Item(NUMBER,数字),
	  *                    Item(IMAGE,照片)>
	  *             >
	  * @param dictConfig
	  * @return
	  */
	 private static Map<String,Object> getDictMap(Map dictConfig,String ItemKey,String prefix){
		  Map<String,Object> dictMapTemp=new HashMap<String,Object>();
		  for(Object key :dictConfig.keySet()){
			  
			    String data=(String) dictConfig.get(key);
			    if(data==null||"".equals(data.trim())) continue;
			    
			    Map<String,String> dict=new HashMap<String,String> ();
			    List<Item> dictItemList=new LinkedList<Item> ();
			    
			    String[] items =data.split(";");
			    String[] codeValue=null;
			    for(int i=0;i<items.length;i++) {
			    	codeValue=items[i].split(":");
				    if(codeValue!=null && codeValue.length==2){
				     dict.put(codeValue[0], codeValue[1]);
				     dictItemList.add(new Item(codeValue[0], codeValue[1]));
				    }
			    }
			    String keyU=prefix+""+key.toString().toUpperCase();
			    dictMapTemp.put(keyU,dict);
			    dictMapTemp.put(keyU+ItemKey, dictItemList);
		  }
		  return dictMapTemp;
	  }

}
