package com.peak.framework.common.jdbc;

import java.sql.SQLException;


/**
 * 功能描述：表主键生成器
 * @author wzy
 * @date 2023/3/21 9:45
 */
public interface IPrimaryKey {


	/**
	 * 默认的主键生成器实例
	 */
	IPrimaryKey DEFAULT=PrimaryKey.getInstance();
    
    
	/**
	 * 功能描述：   获取sequence 
	 * @param  tableName 大写形式的表名
	 * @return 下一个可用的sequene
	 */

	long  getSequence(String tableName) throws SQLException;
	
	/**
	 * 
	 * 功能描述：在做批处理操作的时候，如果连续获取的sequence超过1000个，在调用getSequence方法前先调用
	 * 本方法准备sequence. 可以有效的提高性能，减少数据库获取sequence的更新工作。
	 * @Deprecated
	 * @param tableName  大写形式的表名
	 * @param amount  需要准备的sequence总数 
	 * @return 是否准备成功
	 */
	boolean  prepareSequence(String tableName,int amount)throws SQLException;
	
	/**
	 * 
	 * 
	 * 功能描述：获取指定表特定数量的sequence,当再次调用 getSequence(String tableName)将绕过最少amount个数量的sequence。
	 * 调用这个方法将绕过获amount个可用的sequence。换句话说表示调用者已经获得了 [returnValue,returnValue+amount)范围内的
	 * sequence,
	 * 最小可用seq 是返回值,返回值本身也是可用的。 最大可用的seq 是返回至+amount-1。可用总数是amount
	 * @Deprecated
	 * @param  tableName 大写形式的表名
	 * @param  amount sequence个数
	 * @return 起始的sequence(本身可用）
	 **/
	long jumpSequence(String tableName,int amount) throws SQLException;
	/**
	 * 将主键还原为yyyy-MM-dd HH:mm:ss "|" + datacenterId + "|" +seq  + "|" +workid
	 * @param sequence 主键id
	 * @return java.lang.String
	 * @author wzy
	 * @date 2023/3/21 21:37
	 */
	String parse(long  sequence);


}