package com.peak.framework.common.jdbc;

import com.peak.framework.key.IKey;

import java.sql.SQLException;


/**
 * 功能描述:主键生成器最简单的实现 效率:一个表的生成效率是 10万/一秒(最慢,间隔60秒) 连续取的效率是260万/一秒 这个类是线程安全的
 * 如果使用sequence请为这个类提供单独的数据库连接 这个类一般作为一个单例使用
 * @author wzy
 * @date 2023/3/21 9:44
 */
public class PrimaryKey implements IPrimaryKey {

	private static final PrimaryKey _SELF = new PrimaryKey();


	protected PrimaryKey() {
		super();
	}

	public static IPrimaryKey getInstance() {
		return _SELF;
	}

	/**
	 * 功能描述：获取特定表的sequence
	 * 
	 * @param tableName
	 *            表名 最好是大写
	 * @return 返回当前可用sequenece
	 */
	public long getSequence(String tableName) throws SQLException {
		 return IKey.DEFAULT.getKey(tableName);

	}

	/**
	 * 功能描述：准备指定表特定数量的sequence,为连续amount次seq.next做准备工作。避免频繁的数据库操作。
	 * 
	 * @param amount
	 *            准备的seq总数 指定小于 Sequence.step=50直接返回true
	 * @return 是否准备妥当
	 */
	public boolean prepareSequence(String tableName, int amount) {
		 return true;
	}

	/**
	 * 功能描述：获取指定表特定数量的sequence,再次调用seq.next将绕过最少amount个数量的sequence。调用这个方法
	 * 将获得绕过amount个可用的sequence, 最小的可用seq 是返回值,中返回值本身也是可用的。 最大可用的seq 是返回至+amount
	 * ,这个之本身可用。可用总数是amount
	 * 
	 * @param amount
	 *            绕过的seq总数
	 * @return 返回绕过的sequence的第一个可以用的sequence
	 */
	public long jumpSequence(String tableName, int amount) {
		return IKey.DEFAULT.jumpKey(tableName,amount);
	}
	public String parse(long sequence) {
		return IKey.DEFAULT.parse(sequence);
	}
}
