/**
 * 
 */
package com.peak.framework.common.jdbc.dialect;

/**
 *功能描述：IDialect   
 *@author Administrator
 *@version 2012-3-23 下午03:31:14 1.0v
 *comment:
 *debug:
 */
public interface IDialect {  
	
	     public boolean supportsLimit();

	     public boolean supportsLimitOffset() ;
	    /**
	     * 取得统计数量的sql语句.
	     * @param sql 用户提供的sql.
	     * @return 封装后的计数sql语句.
	     */
	    public String getCountSql(String sql);
	    /**
	     * 将sql变成分页sql语句,直接使用offset,limit的值作为占位符.</br>
	     * 源代码为: getLimitString(sql,offset,String.valueOf(offset),limit,String.valueOf(limit))
	     */
	    public String getLimitString(String sql, int offset, int limit);
	    
	    /**
	     * 将sql变成分页sql语句,提供将offset及limit使用占位符(placeholder)替换.
	     * <pre>
	     * 如mysql
	     * dialect.getLimitString("select * from user", 12, ":offset",0,":limit") 将返回
	     * select * from user limit :offset,:limit
	     * </pre>
	     * @return 包含占位符的分页sql
	     */
	    public String getLimitString(String sql, int offset,String offsetPlaceholder, int limit,String limitPlaceholder);
}
