package com.peak.framework.common.jdbc.dialect;
/**
 * oracle 方言.
 * @author 赵国栋
 *  
 *
-- 0.24 但是不支持 排序  ，distance
select  *
  from (select rownum rn, cu.* from c_user cu where rownum < 197030)
 where rn > 197000
--2.6
select  *
  from (select rownum rn, cu.* from c_user cu )
 where  rn < 197030 and rn > 197000
--2.5s 但是不支持 排序
select * from c_user where usr_id in
       (select usr_id
          from (select rownum rn ,cu.usr_id from c_user cu   where rownum < 190010)
          where rn> 190000
        )   
--2.5
select * from c_user where usr_id in
(select usr_id
  from (select t.*, rownum rn
          from (select cu.usr_id from c_user cu  ) t
         where rownum < 190010)
 where rn > 190000)
--5.5s
select * from c_user where usr_id in
(select usr_id
  from (select t.*, rownum rn
          from (select cu.usr_id from c_user cu    order by cu.name) t
         where rownum < 190010)
 where rn > 190000)
--7.46s
select * from c_user where usr_id in
(select usr_id
  from (select t.usr_id, rownum rn
          from (select usr_id  from c_user cu    order by cu.name) t
        )
where rn < 190010 and rn > 190000)
--9.0
select *
  from (select t.*, rownum rn
          from (select *  from c_user cu    order by cu.name) t
           where rownum < 190010 )
where  rn > 190000

--15s--无安全使用
select *
  from (select t.*, rownum rn
          from (select *  from c_user cu    order by cu.name) t
        )
where rn < 190010 and rn > 190000

如果需要高效的sql 请编写这样的语句 并且不支持排序
select filedname,rownum rownum_ from tablName where [rownum_]

1.[rownum_] 将被替换为 rownum <=[end]
*/

public class OracleDialect extends Dialect{
	
	public boolean supportsLimit() {
		return true;
	}
	public boolean supportsLimitOffset() {
		return true;
	}
	public String getLimitString(String sql, int offset,String offsetPlaceholder, int limit, String limitPlaceholder) {
		sql = sql.trim();
		String sqlLower=sql.toLowerCase();
		StringBuffer pagingSelect = new StringBuffer( sql.length()+100 );
		boolean isForUpdate = false;
		if(limit==Integer.MAX_VALUE) return sql; 
	
		if(offset<1) offset=1;
		int forUpdateIndex=sqlLower.indexOf("for update");
		if (forUpdateIndex >-1) {
			 sql=sql.substring(0,forUpdateIndex );
			 isForUpdate = true;
		}
		if(!twoLayers(sql,sqlLower, offset,  limit, pagingSelect)){
		    threeLayers( sql, offset,  limit, pagingSelect);
		}
		if (isForUpdate ) {
			pagingSelect.append("for update" );
		}
		return pagingSelect.toString();
	 }
	 private void threeLayers(String sql,int offset, int limit,StringBuffer pagingSelect){
		    pagingSelect.append("select * from (");
			//if (offset !=1) {
			pagingSelect.append("select row_.*, rownum rownum_ from ( ");
		    //}
			pagingSelect.append(sql);
			
			long end = offset+limit;
			//if (offset !=1) {
				  pagingSelect.append(")row_ ) where  rownum_ >= " + offset +" and  rownum_ < " + end );
			//}
			//else {
			//    pagingSelect.append(") where rownum < " + end);
			//}	
	   }
	  /**
	    * 功能描述：最外一层 select 没有使用 
	    *  order by , distinct 
	    * @param sql
	    * @param offset
	    * @param limit
	    * @param pagingSelect
	    */
	   private void twoLayersDeal(String sql,int offset, int limit,StringBuffer pagingSelect){
		    
			if (offset != 1) {
				pagingSelect.append("select * from ( ");
			}
			long end = offset+limit;
			String rownum ="rownum < " + end  ;
			//不区分大小写替换
			sql=sql.replaceFirst("(?i)\\[rownum_\\]", rownum);
			pagingSelect.append(sql);
			if (offset != 1) {
				pagingSelect.append(" )where rownum_  >= " + offset);
			}
	   }
	   // order by , * ,rownum rownum_
	   // 替换 where 为 where rownum_<=  添加
	   //
	   private boolean twoLayers(String sql, String sqlLower,int offset, int limit,StringBuffer pagingSelect){
		   //用户知道使用优化分页
		   if(sqlLower.indexOf("rownum_")>6 && sqlLower.indexOf("[rownum_]")>6){
			   twoLayersDeal( sql, offset, limit, pagingSelect);
			   return true;
		   }
		   //使用 ，非空的
		   if(sqlLower.indexOf(" * ")>-1){//不支持
			   return false;
		   }
		   if(sqlLower.indexOf(" distinct")>-1){//不支持
			   return false;
		   }
		   if(sqlLower.indexOf("order by")>-1 || sqlLower.indexOf(" order ") >-1){//不支持   from 前的order 字段会导致不应该返回false
			   return false;
		   }
		   if(sqlLower.indexOf("group by")>-1 ){
			   return false;
		   }
		   int formSet=sqlLower.indexOf("from");
		   int whereSet=sqlLower.indexOf("where");
		   int formSet2=sqlLower.indexOf("from",formSet+4);
		   int whereSet2=sqlLower.indexOf("where",whereSet+5);
		   if(formSet2==-1 && whereSet2==-1){
			     sql=sql.replaceFirst("(?i)from", ",rownum as rownum_ from");
			   if(whereSet!=-1)
			     sql=sql.replaceFirst("(?i)where", "where  [rownum_] and");
			   else
				 sql=sql+" where  [rownum_]  ";
			    twoLayersDeal( sql, offset, limit, pagingSelect);
			    return  true;
		   }
		   return false;
	   }
	   public static void main(String[] args){
		   OracleDialect orale=new OracleDialect();
		   String[] sqls={" select 1 from dual"
				           ,"select sum(1) from dual where c=1"
				           ,"select 1 from dual  order by 1"
				           ,"select 1 from dual  where c=1"
				           ,"select count(1) from dual where c=1"
//				           ,"select * from dual where c=1"
//				           ,"select distinct* from dual where c=1"
//				           ,"select distinct* from dual where c=1 oder by dex"
//				           ,"select sdt from dual where c=1 oder by dex"
//				           ,"select sdt from dual ,dual2 where c=1 oder by dex"
//				           ,"select sdt,(select * from dual) as ff from dual ,dual2 where c=1 oder by dex"
//				           ,"select sdt,(select * from dual) as ff from dual ,dual2 where c=1 "
//				           ,"select sdt from dual ,dual2 where c=1 "
//				           ,"select sdt from dual ,dual2  "
//				           ,"select sdt from dual  "
		                   };
		   for(int i=0;i<sqls.length;i++){
			   System.out.println(sqls[i]+":");
			   System.out.println(orale.getLimitString(sqls[i], 1, 10));
		   }
//		   String sql="select r [rownum_] from dual where c=1";
//		   System.out.println(sql.replaceFirst("(?i)\\[rownum_\\]", "oooo"));
//		   System.out.println(sql.replaceFirst("(?i)from", "oooo"));
	   }
}