package com.peak.framework.common.page;

import java.io.Serializable;
import java.util.List;
/**
 * 功能描述：分页信息
 * 第一页从1开始
 * @author  赵国栋
 */
public interface IPage<T> extends Serializable
{
	/**
	 * 功能描述：页码
	 * @return
	 */
	public int  getPageNumber() ;
	public void setPageNumber(int pageNumber);
	/**
	 * 功能描述：每页大小
	 * @param pageSize
	 */

	public void setPageSize(int pageSize) ;
	public int getPageSize();
	/**
	 * 功能描述：总页数
	 * @param count
	 */
	public void setTotalCount(int count) ;
	public int getTotalCount();
	/**
	 * 功能描述：是否实现最近查询
	 * @param recent
	 */
	public void setRecent(boolean recent) ; 
	public boolean isRecent();
	/**
	 * 功能描述：查询结果
	 * @param results
	 */
	public void setResult(List<T> results) ;
	public List<T> getResult();
	public List<T> getClearResult();

	/**
	 * 功能描述：排序的列,可以同时多列,使用逗号分隔,如 username desc,age asc
	 * @return
	 */
	public void setSortColumns(String sortColumns);
    public String getSortColumns();
	
}

