package com.peak.framework.common.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * 功能描述：分页信息
 * 第一页从1开始
 * @author 赵国栋
 */
public class Page<T> implements IPage<T>
{
    /**
     * 页码
     */
	protected int pageNumber=1; 
	/**
	 *  每页最大记录数
	 */
	protected int pageSize=15;
	/**
	 * 总记录数
	 */
	protected int totalCount = 0;
	/**
	 * 排序字段
	 */
	private String sortColumns;
	/**
	 * 是否利用上一次查询条件
	 */
	private  boolean  recent=false;
	/**
	 * 查询的数据结果
	 */
	protected List<T> result;
	public int getPageNumber() {
		return pageNumber;
	}
	public void setPageNumber(int pageNumber) {
		if(pageNumber<1){
			this.pageNumber =1;
		}else{
		  this.pageNumber = pageNumber;
		}
	}
	public void setPageSize(int pageSize) {
		if(pageSize<1){
			this.pageSize =1;
		}else{
		   this.pageSize = pageSize;
		}
	}
	public int getPageSize() {
		if(pageSize<1)return 1;
		return pageSize;
	}
	public void setTotalCount(int totalCount) {
		this.totalCount = totalCount;
	}
	public int getTotalCount() {
		return totalCount;
	}
	public void setRecent(boolean recent) {
		this.recent = recent;
	}
	public  boolean isRecent() {
		return this.recent;
	}
	public String getSortColumns() {
		return sortColumns;
		
	}
	/**
	 * 排序的列,可以同时多列,使用逗号分隔,如 username desc,age asc
	 * @return
	 */
	public void setSortColumns(String sortColumns) {
		 this.sortColumns =sortColumns; 
		 if(this.sortColumns!=null && this.sortColumns.length()>0){
		    this.sortColumns =_checkSortColumns(sortColumns); 
		 }
	}
	/**
	 * 排序列格式检查  列名  [desc|asc],列名  [desc|asc]
	 * 1:每项长度不能超过100，
	 * 2:替换掉所有 列名中包含的空格，
	 * @param sortColumns
	 * @return
	 */
	 private static String  _checkSortColumns(String sortColumns){
    	 String[] sort2=sortColumns.toLowerCase().split(",");
    	 StringBuffer sortColums=new StringBuffer();   
    	 String flag="";
    	 String descOrasc=" ASC";
    	 for(String sort:sort2){
    		  if(sort==null||sort.length()==0){
    			  continue;
    		  }
    		  descOrasc="  ASC";
    		  if(sort.indexOf(" asc")>-1){
    			  sort = sort.replace(" asc", "");
    			  descOrasc=" ASC";
    		  }
    		  if(sort.indexOf(" desc")>-1){
    			  sort = sort.replace(" desc", "");
    			  descOrasc=" DESC";
    		  }
    		  sort = sort.trim();
    		  //列名表达式
    		  if(!sort.matches("^[a-zA-Z0-9_\\$\\.]{1,100}$")){
    			  continue;
    		  }
    		  if(sort.matches("^[0-9]{1,100}$")){
    			  continue;
    		  }
    		  sortColums.append(flag);
    		  sortColums.append(sort);
    		  sortColums.append(descOrasc);
    		  flag=",";
    	 }
    	 if(sortColums.length()==0){
    		 return null;
    	 }
    	 return  sortColums.toString().toUpperCase();
    }
	
	public Page() {
	}
	public Page(int pageNumber,int pageSize,int totalCount) {
		this(pageNumber,pageSize,totalCount,new ArrayList(0));
	}
	
	public Page(int pageNumber,int pageSize,int totalCount,List<T> result) {
		if(pageSize <= 0) throw new IllegalArgumentException("[pageSize] must great than zero");
		this.pageSize = pageSize;
		this.pageNumber = PaginationUtil.computePageNumber(pageNumber,pageSize,totalCount);
		this.totalCount = totalCount;
		setResult(result);
	}

	public void setResult(List<T> elements) {
		if(elements == null) throw new IllegalArgumentException("'result' must be not null");
		this.result = elements;
	}
	
    /**
     * 当前页包含的数据
     *
     * @return 当前页数据源
     */
	public List<T> getResult() {
		return result;
	}
	/* (non-Javadoc)
	 * @see com.peak.framework.common.page.IPage#getClear()
	 */
	public  List<T> getClearResult() {
		  List<T> resultTemp=result;
		  result=Collections.emptyList();
		  return resultTemp;
	}
	
	public static void  main(String[] args) {
		 String[] sort2= { "200" ,"a.b","a2000","a200b" ,"200b"};   
    	 boolean flag=true;
    	 for(String sort:sort2){
    		  flag=true;
    		  sort = sort.trim();
    		 
    		  //列名表达式
    		  if(!sort.matches("^[a-zA-Z0-9_\\$\\.]{1,100}$")){
    			  flag=false;
    		  }
    		  if(sort.matches("^[0-9]{1,100}$")){
    			  flag=false;
    		  }
    	 }
    	
	}

}

