package com.peak.framework.common.page;

import java.util.ArrayList;
import java.util.List;

//import edu.emory.mathcs.backport.java.util.Collections;
/**
 * 
 * 功能描述: 分页工具类
 * @author zhao
 * @version 2011-6-16 v1.0
 */
public class PaginationUtil  {
	private IPage page;
	public IPage getPage() {
		return page;
	}
	public  PaginationUtil(IPage page){
	   this.page=page;
	   //注释掉否则会导致学员端无限翻页
//	   int lastPageNumber= this.getLastPageNumber();
//	   if(lastPageNumber<page.getPageNumber()){
//		   page.setPageNumber(lastPageNumber);
//	   }
	   if(page.getPageNumber()<1){
		   page.setPageNumber(1);
	   }
	}
	/**
	 * 功能描述;获取当前页的首条记录的记录号
	 * @return 从1开始 oracle rownum从1开始 mysql 从0开始
	 */
	public  int getThisPageFirstRowNumber() {
		int pageNumber=page.getPageNumber();
		int pageSize=page.getPageSize();
		if(pageSize <= 0) throw new IllegalArgumentException("[pageSize] must great than zero");
		return (pageNumber - 1) * pageSize+1;
	}
	public int getTotalCount(){
		return page.getTotalCount();
	}
	 /**
     * 功能描述：获取当前页的末条记录的记录号
     * @return 当前页的末条数据的行编码
     */
	public   int getThisPageLastRowNumber() {
		int pageNumber=page.getPageNumber();
		int pageSize=page.getPageSize();
		int fullPage = pageNumber* pageSize;
		return page.getTotalCount() < fullPage ? page.getTotalCount() : fullPage;
	}
	 /**
     * 功能描述：获取当前页
     * @return 当前页的页码
     */
	public  int getThisPageNumber() {
		return page.getPageNumber();
	}
    /**
     * 功能描述：是否是首页（第一页），第一页页码为1
     * @return 首页标识
     */
	public  boolean isFirstPage() {
		return this.getThisPageNumber() == 1;
	}
	 /**
     * 功能描述：是否是最后一页
     *
     * @return 末页标识
     */
	public  boolean isLastPage() {
		return this.getThisPageNumber() >= this.getLastPageNumber();
	}
	 
    /**
     * 功能描述：是否有上一页
     * @return 上一页标识
     */
	public  boolean isHasPreviousPage() {
		return this.getThisPageNumber() > 1;
	}
    /**
     * 功能描述：获取最后一页页码，也就是总页数
     *
     * @return 最后一页页码
     */
	public  int getLastPageNumber() {
		return this.computeLastPageNumber(page.getTotalCount(), page.getPageSize());
	}
    /**
     * 功能描述：是否有下一页
     * @return 下一页标识
     */
	public  boolean isHasNextPage() {
		return this.getLastPageNumber() > this.getThisPageNumber();
	}
    /**
     * 功能描述：获取下一页编码
     *
     * @return 下一页编码
     */
	public  int getNextPageNumber() {
		return this.getThisPageNumber() + 1;
	}
    /**
     * 功能描述：获取上一页编码
     * @return 上一页编码
     */
	public  int getPreviousPageNumber() {
		return this.getThisPageNumber() - 1;
	}
	  /**
     * 功能描述： 得到用于多页跳转的页码
     * @return
     */
	public List<Integer> getLinkPageNumbers() {
		return this.generateLinkPageNumbers(
             this.getThisPageNumber(), 
             this.getLastPageNumber(),10);
	}
	
	
//	/**
//	 * 功能描述：将sortColumns进行解析以便返回SortInfo以便使用
//	 * @return
//	 */
//	public  List<SortInfo> getSortInfos() {
//		return Collections.unmodifiableList(SortInfo.parseSortColumns(page.getSortColumns()));
//	}
   
    /**
     * 功能描述：返回页面需要显示的页码
     * @param currentPageNumber
     * @param lastPageNumber
     * @param count
     * @return
     */
	public  List<Integer> generateLinkPageNumbers(int currentPageNumber,int lastPageNumber,int showPageSize) {
		int avg = showPageSize / 2;
		
		int startPageNumber = currentPageNumber - avg;
		if(startPageNumber <= 0) {
			startPageNumber = 1;
		}
		
		int endPageNumber = startPageNumber + showPageSize - 1;
		if(endPageNumber > lastPageNumber) {
			endPageNumber = lastPageNumber;
		} 
		
		if(endPageNumber - startPageNumber < showPageSize) {
			startPageNumber = endPageNumber - showPageSize;
			if(startPageNumber <= 0 ) {
				startPageNumber = 1;
			}
		}
		List<Integer> result = new ArrayList<Integer>();
		for(int i = startPageNumber; i <= endPageNumber; i++) {
			result.add(new Integer(i));
		}
		return result;
	}
	/**
	 * 功能描述：计算最后一页的页码
	 * @param totalElements
	 * @param pageSize
	 * @return
	 */
	
	public static int computeLastPageNumber(int totalElements,int pageSize) {
		int result = totalElements % pageSize == 0 ? 
				totalElements / pageSize 
				: totalElements / pageSize + 1;
		if(result <= 1) result = 1;
		return result;
	}
	/**
	 * 功能描述：返回有现实意义的页码
	 * @param pageNumber
	 * @param pageSize
	 * @param totalElements
	 * @return
	 */
    public static int computePageNumber(int pageNumber, int pageSize,int totalElements) {
		if(pageNumber <= 1) {
			return 1;
		}
	   int lastPageNumber=computeLastPageNumber(totalElements,pageSize);
       if (Integer.MAX_VALUE == pageNumber
				|| pageNumber >lastPageNumber ) { //last page
			return lastPageNumber;
	   }
	   return pageNumber;
    }
}
