package com.peak.framework.common.string;

import com.peak.common.util.StringUtil;
import com.peak.prd.base.util.ExceptionUtil;
import lombok.extern.slf4j.Slf4j;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
  
/**  
 *   
 * 汉字转化为全拼     
 * JDK版本: 1.6  
 */
@Slf4j
public class CnToSpell {   
	 static HanyuPinyinOutputFormat outputFormat=new HanyuPinyinOutputFormat();
	 static {
		outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
		outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		outputFormat.setVCharType(HanyuPinyinVCharType.WITH_V );
	 }
     /**
     * 功能描述：获取汉语拼音
     * @param chinese 待转化的汉字
     * @return 返回空格分隔汉语拼音，如果转换错误返回 "";
     */
     public  static String getPinyin(String chinese) {
         if(StringUtil.isNullorEmptyStr(chinese)) {
			 return "";
		 }
		 HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
		 format.setCaseType(HanyuPinyinCaseType.LOWERCASE); // 小写
		 format.setToneType(HanyuPinyinToneType.WITHOUT_TONE); // 不带声调

		 StringBuilder pinyin = new StringBuilder();
		 for (char c : chinese.toCharArray()) {
			 if (Character.toString(c).matches("[\\u4E00-\\u9FA5]")) { // 中文字符
				 try {
					 String[] pinyins = PinyinHelper.toHanyuPinyinStringArray(c, format);
					 if (pinyins != null && pinyins.length > 0) {
						 pinyin.append(pinyins[0]); // 取第一个发音（多音字需上下文处理）
					 }
				 } catch (BadHanyuPinyinOutputFormatCombination e) {
					 pinyin.append(c); // 转换失败保留原字符
					 log.error( "getPinyin error: " + ExceptionUtil.getStackTraceString(e));
				 }
			 } else {
				 pinyin.append(c); // 非中文直接保留
			 }
		 }
		 return pinyin.toString();
     }

	public static void main(String[] args) {
		String c = "你好，中国";
		log.debug(  getPinyin(c));
	}
}  
