package com.peak.framework.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang.StringUtils;
/**
 * @author badqiu
 */
public class DateConvertUtils {
	
	public static java.util.Date parse(String dateString,String dateFormat) {
		return parse(dateString, dateFormat,java.util.Date.class);
	}
	
	@SuppressWarnings("unchecked")
	public static <T extends java.util.Date> T parse(String dateString,String dateFormat,Class<T> targetResultType) {
		if(StringUtils.isEmpty(dateString))
			return null;
		DateFormat df = new SimpleDateFormat(dateFormat);
		try {
			long time = df.parse(dateString).getTime();
			java.util.Date t = targetResultType.getConstructor(long.class).newInstance(time);
			return (T)t;
		} catch (ParseException e) {
			String errorInfo = "cannot use dateformat:"+dateFormat+" parse datestring:"+dateString;
			throw new IllegalArgumentException(errorInfo,e);
		} catch (Exception e) {
			throw new IllegalArgumentException("error targetResultType:"+targetResultType.getName(),e);
		}
	}
	
	public static String format(java.util.Date date,String dateFormat) {
		 if(date == null) return null;
		 return new SimpleDateFormat(dateFormat).format(date);
	}
	/**
	 * 
	* @Description: 日期加分钟后，转换为日期
	* @param d1
	* @param dDay
	* @return
	* @return java.util.Date
	* @throws
	 */
	public static java.util.Date addMinutes(java.util.Date d1, int minutes) {
		try {
			long lDate = d1.getTime();
			long lDay = (long) (minutes * 60 * 1000);
			return new java.util.Date(lDate + lDay);
		} catch (Throwable e) {
			return null;
		}
	}
}
