package com.peak.framework.key;

/**
 * 生成主键唯一值
 * @author wzy
 * @date 2023/3/21 9:33
 */
public interface IKey {
    /**
     * 默认的主键生成器实例
     */
    IKey DEFAULT=Key.getInstance();
    /**
     * 功能描述：获取一个唯一主键
     * @return 主键Id
     */
    long getKey();

    /**
     * 获取表新的主键Id
     * @param tableName 大写表名
     * @return 表新的主键Id
     */
    //每个表是一个独立Idworker从而进一步避免主键重复和每个表能够再1秒内生成4369个Id
    long getKey(String tableName);
    /**
     * 功能描述：获取指定表特定数量的key,再次调用getKey 将绕过最少amount个数量的key。调用这个方法
     * 将获得绕过amount个可用的sequence,
     * 最小的可用key 是返回值,中返回值本身也是可用的。
     * 最大可用的key 是返回至+amount ,这个之本身可用。可用总数是amount
     * @param  amount 绕过的seq总数
     * @return 返回绕过的key 的第一个可以用的key
     */
    long jumpKey(String tableName, int amount);
    /**
     *  清除每个表的idworker缓存
     * @author wzy
     * @date 2023/3/21 22:12
     */
    void clear();
    /**
     * 分布式的时候，每台服务需要配置这个生成因子 ，每台服务器不能完全相同
     * 同一个部署机房最好使用同一个databaseId，使用不同的workerId
     * @param databaseId 数据中心 id [0,31)
     * @param workerId 应用发布的id  [0,31)
     */
    void setConfig(int databaseId,int workerId);

    /** 
     * 将主键还原为yyyy-MM-dd HH:mm:ss "|" + datacenterId + "|" +seq  + "|" +workid
     * @param key 主键Id
     * @return 主键还原为yyyy-MM-dd HH:mm:ss "|" + datacenterId + "|" +seq  + "|" +workid
     * @author wzy
     * @date 2023/3/21 21:39
     */
    String parse(long key);
}
