package com.peak.framework.key;

import org.apache.commons.logging.Log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author zhaoguodong
 *   63.7年不重复，每秒钟可生成4369个 16位十进位 long类型数据 ，兼容 javaScript
 *   type=1 1:顺序生成，2：乱序生成。
 */
public class IdWorker {

	//1： 生成id 的效率,可通过调整这三个参数控制, Math.pow(2,sequenceBits)/60 
	//   2^18/60=262144/60=4369   
	//   2^19/60-524288/60=8738  
	//   2^20/60=1048576/60=17466
	//调节时候注意保持 workerIdBits+datacenterIdBits+sequenceBits=28;
	//2：  64-28=36  一位符号位  2^35=34359738368 
	//3： 一年 有 60*24*365.25=525960 分钟
	//4： javascript 最大整数 +- 2^53=  -9007199254740992  +9007199254740992   16位
	//5: java 最大可用来标示时间的位数  53-28=26   2^25=33554432  
	//6: java 最大可表示的年数   2^25/ 60*24*365.25=33554432/ 525960=63.79 年
	// 顺序  25位的时间前缀  + 5位datacenter+ 5位的机器 id + 18位的sequence避免并发的数字(12位不够用时强制得到新的时间前缀); =54位
	private final  long workerIdBits = 5L;
	private final  long datacenterIdBits = 5L;
	private final  long timeBits = 25L;
	private final  long sequenceBits = 18L;//262144

	private static Log LOGGER = org.apache.commons.logging.LogFactory.getLog(IdWorker.class);
	/**
	 * 2016-1-1 8:00:00
	 */
	private final long twepoch = 1451606400000L;
	private final long maxWorkerId = -1L ^ (-1L << workerIdBits);
	private final long maxDatacenterId = -1L ^ (-1L << datacenterIdBits);
	
	private final long workerIdShift = sequenceBits;
	private final long datacenterIdShift = sequenceBits + workerIdBits;
	private final long timestampLeftShift = sequenceBits + workerIdBits + datacenterIdBits;
	
	private final long datacenterIdShift2 = sequenceBits + workerIdBits+timeBits;
	private final long sequenceShift2 = workerIdBits+timeBits;
	private final long workerIdShift2 = timeBits;
	
	private final long sequenceMask = -1L ^ (-1L << sequenceBits);//
	private long  lastTimestamp = -1L;
    private long  type=2; //1:顺序 2:乱序
	/**
	 * 
	 */
	private long workerId = 0;
	private long datacenterId = 0;
	private long sequence = 0L;
	private long sequence_2 = 0L;

	/**
	 * @param workerId
	 * @param datacenterId
	 */

	public IdWorker(int datacenterId, int workerId) {
		if (workerId > maxWorkerId || workerId < 0) {
			throw new IllegalArgumentException(
					String.format("workerId can't be greater than %d or less than 0.", maxWorkerId));
		}
		if (datacenterId > maxDatacenterId || datacenterId < 0) {
			throw new IllegalArgumentException(
					String.format("datacenterId can't be greater than %d or less than 0.", maxDatacenterId));
		}
		this.workerId = workerId;
		this.datacenterId = datacenterId;
	}

	/**
	 * 
	 * 
	 * 
	 * @return
	 * 
	 */

	public synchronized long next() {
		long id = 0L;
		long timestamp = timeGen();
		checkUpdatTime(timestamp);
		if(type==1){
			if (timestamp == lastTimestamp) {
				sequence = (1 + sequence) & sequenceMask;
				if (0 == sequence) {
					timestamp = tilNextTime(lastTimestamp);
				}
			} else {
				sequence = 0;
			}
		}else{
			if (timestamp == lastTimestamp) {
			    sequence = (1 +sequence) & sequenceMask;
			    sequence_2 =(1+sequence_2) & sequenceMask;
			    if (0 == sequence_2) {
				   timestamp = tilNextTime(lastTimestamp);
			    }
		    }else{
		    	sequence_2=0;
		        sequence = (1 + sequence) & sequenceMask;
		    }
		}
		lastTimestamp = timestamp;
		if(this.type==1){
			  id = (timestamp << timestampLeftShift) | (datacenterId << datacenterIdShift) | (workerId << workerIdShift)
				| sequence;
	    }else {
//	    	  id =(datacenterId <<datacenterIdShift2)|(sequence << sequenceShift2)|
//	    			  (workerId << workerIdShift2) | timestamp;
	    	  id =(datacenterId <<48)|(sequence << 30)|
	    			  (workerId << 25) | timestamp;
	    }
		return id;

	}
	private void checkUpdatTime(long timestamp) {
		if (timestamp < lastTimestamp && datacenterId<maxDatacenterId) {//TODO
			 datacenterId++;
			 long yel=(lastTimestamp-timestamp);
			 LOGGER.warn("系统时间被回调了  ，为保证不发生主键冲突 ， 请不要在 （"+yel +"）  分钟内不要重启服务器 ,如在（"+yel +"）  分钟内重启服务器，请配置  pk_databaseId=1 （applicaiton.properties");
		     //throw new RuntimeException(String.format("clock moved backwards. refusing to generate id for %d milliseconds.", lastTimestamp - timestamp));
		}
	}
	
	/**
	 * 方法最少运行2毫秒，
	 * @param amount
	 * @return
	 */
	public synchronized long jump(int amount) {
		    if(amount<0 || amount>sequenceMask-1){
		    	throw new IllegalArgumentException(
						String.format("amount can't be greater than %d or less than 0.", amount));
		    }
		    
		    long timestamp = lastTimestamp;
		    long seq=next();
		    if(amount<=(sequenceMask-sequence)){
		    	   sequence=(sequence+amount-1);
		    }else{
		    	   timestamp = tilNextTime(lastTimestamp);
		    	   seq=next();
				   sequence =amount-1;
		    }
		    lastTimestamp=timestamp;
		    return seq;
	}
	/**
	 * @param lastTimestamp
	 * @return
	 */
	protected long tilNextTime(long lastTimestamp) {
		long timestamp = timeGen();
		while (timestamp <= lastTimestamp) {
			 try {
				 Thread.sleep(1000);
			 } catch (InterruptedException e) {
				 e.printStackTrace();
			 }
			 LOGGER.error("系统获取主键，超出  "+ sequenceMask+"/分钟 请优化主键效率");
			 timestamp = timeGen();
		}
		return timestamp;
	}

	public String parse(long id) {
		if(this.type==1){
			long seq = (id << (64 - sequenceBits)) >>> (64 - sequenceBits);

			long workid = id << (64 - sequenceBits - workerIdBits) >>> (64 - workerIdBits);
			
			long datacenterId = id << (64 - sequenceBits - workerIdBits - datacenterIdBits) >>> (64 - datacenterIdBits);
			long m = id >> timestampLeftShift;

			long t = m * 60000 + twepoch;
			Date date = new Date(t);
			DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return format.format(date) + "|" + datacenterId + "|" + workid + "|" + seq;
			
	    }else {
	    	//  id =(datacenterId <<datacenterIdShift2)| (sequence << sequenceShift2)|
	    	//		  (workerId << workerIdShift2) | timestamp;
			long datacenterId = id<<(64-timeBits-workerIdBits-sequenceBits-datacenterIdBits) >>>(64-datacenterIdBits);
			long seq = id << (64- timeBits-workerIdBits-sequenceBits) >>> (64- sequenceBits);	    	
			long workid =id<<(64 -timeBits-workerIdBits)>>>(64-workerIdBits);	
			long m = id << (64 - timeBits) >>> (64 - timeBits);;
			long t = m * 60000 + twepoch;
			Date date = new Date(t);
			DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return format.format(date) + "|" + datacenterId + "|" +seq  + "|" +workid ;
	    }
	
	}

	
	/**
	 * 
	 * @return
	 * 
	 */
	protected long timeGen() {
		return (System.currentTimeMillis() - twepoch) / 60000;
	}
	public static void main(String[] args) {
		IdWorker idw = new IdWorker(5, 30);
		idw.type=2;
		for (int i = 0; i < 10; i++) {
			long id = idw.next();

//			try {
//				Thread.sleep(60000);
//			} catch (InterruptedException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
		}
		
		
		
	}
}