package com.peak.framework.key;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
/**
 * 需要在application.properties文件中配置 
 * pk_databaseId=0;
   pk_workerId=0;
 * @author zhao
 *
 */

public class Key  implements IKey  {
	private static Log logger = org.apache.commons.logging.LogFactory.getLog(Key.class);
	
	/**
	 * 表名 tblKey
	 */
	private  Map<String ,IdWorker> tableNameMapTblKey=new HashMap<String ,IdWorker>();
	private static final IKey _SELF ;
	static{
		_SELF = new Key();
	}
	

	public static IKey getInstance() {
		return _SELF;
	}
	
	private   int workerId=0;
	private   int databaseId=0;

	public long getKey() {
		  return getKey("com.peak.framework.key.IKey") ;
	}
	public synchronized void clear() {
		   tableNameMapTblKey.clear();
	}
	public  long getKey(String tableName) {
		
		   IdWorker tblKey = getIdObj(tableName);
	       return tblKey.next();
	}
	private IdWorker getIdObj(String tableName) {
		   String tableNameUpper=tableName.toUpperCase();
		   IdWorker tblKey=tableNameMapTblKey.get(tableNameUpper);
           if(tblKey==null){
        	  this.createTableKey(tableNameUpper);
        	  tblKey=tableNameMapTblKey.get(tableNameUpper);
           }
		   return tblKey;
	}
	public long jumpKey(String tableName, int amount) {
		   IdWorker tblKey = getIdObj(tableName);
	       return tblKey.jump(amount);
	}
	protected synchronized void   createTableKey(String tableName) {
		   String tableNameUpper=tableName.toUpperCase();
		   if(tableNameMapTblKey.containsKey(tableNameUpper)) return;
		   IdWorker tblKey=new IdWorker(this.databaseId,this.workerId);
		   tableNameMapTblKey.put(tableNameUpper, tblKey);
	}
	public void setConfig(int  databaseId,int  workerId){
	    	 this.workerId=Math.abs(workerId)%32;
	    	 if(this.databaseId==0 && databaseId!=0){
			     this.databaseId=Math.abs(databaseId)%16;
	    	 }
	    	 
	    	 logger.info("databaseId:" + this.databaseId + ", workerId:" + this.workerId);
	    	 
			 clear();
	}
	public  String parse(long  key){
		 IdWorker tblKey= getIdObj("com.peak.framework.key.IKey");
		 return  tblKey.parse(key);
	}

}

